/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.operator;

import fixture5.TestFixture;
import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.operatorutil.OpenshiftOperatorEnum;
import io.debezium.testing.system.tools.registry.ApicurioOperatorController;
import io.debezium.testing.system.tools.registry.ApicurioOperatorDeployer;
import io.fabric8.openshift.client.OpenShiftClient;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixtureContext(requires={OpenShiftClient.class}, provides={ApicurioOperatorController.class})
public class OcpApicurioOperator
extends TestFixture {
    private final OpenShiftClient ocp = (OpenShiftClient)this.retrieve(OpenShiftClient.class);
    private final String project = ConfigProperties.OCP_PROJECT_REGISTRY;
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurioOperator.class);

    public OcpApicurioOperator(@NotNull ExtensionContext.Store store) {
        super(store);
    }

    public void setup() throws Exception {
        ApicurioOperatorController controller = new ApicurioOperatorDeployer(this.project, this.ocp, null).deploy();
        this.updateApicurioOperator(controller);
        this.store(controller);
    }

    public void teardown() {
        LOGGER.debug("Skipping " + OpenshiftOperatorEnum.APICURIO.getName() + " operator tear down");
    }

    private void updateApicurioOperator(ApicurioOperatorController operatorController) {
        ConfigProperties.OCP_PULL_SECRET_PATH.ifPresent(arg_0 -> ((ApicurioOperatorController)operatorController).deployPullSecret(arg_0));
        operatorController.updateOperator();
    }
}

