/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb.sharded;

import freemarker.template.TemplateException;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseClient;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.sharded.MongoShardKey;
import io.debezium.testing.system.tools.databases.mongodb.sharded.MongoShardedUtil;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoShardedCluster;
import io.debezium.testing.system.tools.databases.mongodb.sharded.ShardKeyRange;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpMongoShardedController
implements MongoDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpMongoShardedController.class);
    private final OcpMongoShardedCluster mongo;
    private final OpenShiftClient ocp;
    private final String project;
    private final Path insertDataScript;

    public OcpMongoShardedController(OcpMongoShardedCluster mongo, OpenShiftClient ocp, String project) {
        this.mongo = mongo;
        this.ocp = ocp;
        this.project = project;
        try {
            this.insertDataScript = Paths.get(this.getClass().getResource("/database-resources/mongodb/sharded/insert-mongos-data.js").toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDatabaseHostname() {
        return this.getService().getMetadata().getName() + "." + this.project + ".svc.cluster.local";
    }

    @Override
    public int getDatabasePort() {
        return 27017;
    }

    @Override
    public String getPublicDatabaseHostname() {
        return this.getDatabaseHostname();
    }

    @Override
    public int getPublicDatabasePort() {
        return this.getDatabasePort();
    }

    @Override
    public String getPublicDatabaseUrl() {
        return this.mongo.getConnectionString();
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password) {
        return this.getDatabaseClient(username, password, "admin");
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password, String authSource) {
        return new MongoDatabaseClient(this.getPublicDatabaseUrl(), username, password, authSource);
    }

    @Override
    public void reload() {
        this.mongo.stop();
        this.mongo.waitForStopped();
    }

    @Override
    public void initialize() throws InterruptedException {
        try {
            this.mongo.executeMongoSh(String.join((CharSequence)"\n", Files.readAllLines(this.insertDataScript)));
            this.mongo.executeMongoSh(MongoShardedUtil.createDebeziumUserCommand(ConfigProperties.DATABASE_MONGO_DBZ_USERNAME, ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD));
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
        this.mongo.getShardReplicaSets().forEach(rs -> {
            try {
                rs.executeMongosh(MongoShardedUtil.createDebeziumUserCommand(ConfigProperties.DATABASE_MONGO_DBZ_USERNAME, ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD), true);
            }
            catch (TemplateException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void addShard(Map<MongoShardKey, ShardKeyRange> rangeMap) {
        this.mongo.addShard(rangeMap);
    }

    public void removeShard() {
        this.mongo.removeShard();
    }

    public OcpMongoShardedCluster getMongo() {
        return this.mongo;
    }

    private Service getService() {
        return (Service)((ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName("mongo-mongos")).get();
    }
}

