/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb.sharded;

import freemarker.template.TemplateException;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.mongodb.sharded.MongoShardKey;
import io.debezium.testing.system.tools.databases.mongodb.sharded.MongoShardedUtil;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoDeploymentManager;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoReplicaSet;
import io.debezium.testing.system.tools.databases.mongodb.sharded.ShardKeyRange;
import io.debezium.testing.system.tools.databases.mongodb.sharded.componentproviders.OcpMongosModelProvider;
import io.debezium.testing.system.tools.databases.mongodb.sharded.componentproviders.OcpShardModelProvider;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.lifecycle.Startable;

public class OcpMongoShardedCluster
implements Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpMongoShardedCluster.class);
    private final int replicaCount;
    private final int configServerCount;
    private final String rootUserName;
    private final String rootPassword;
    private final boolean useInternalAuth;
    private final OpenShiftClient ocp;
    private final OpenShiftUtils ocpUtils;
    private final int initialShardCount;
    private final String project;
    private final List<MongoShardKey> shardKeys;
    private final List<OcpMongoReplicaSet> shardReplicaSets = Collections.synchronizedList(new LinkedList());
    private OcpMongoReplicaSet configServerReplicaSet;
    private OcpMongoDeploymentManager mongosRouter;
    private boolean isRunning = false;

    public void start() {
        if (this.isRunning) {
            LOGGER.info("Sharded mongo cluster already running, skipping initialization");
            return;
        }
        this.deployConfigServers();
        this.deployShards();
        this.deployMongos();
        this.ocpUtils.waitForPods(this.project, this.mongosRouter.getDeployment().getMetadata().getLabels());
        try {
            this.initMongos();
        }
        catch (TemplateException | IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.isRunning = true;
    }

    public void stop() {
        this.shardReplicaSets.parallelStream().forEach(OcpMongoReplicaSet::stop);
        this.configServerReplicaSet.stop();
        this.mongosRouter.stop();
        this.isRunning = false;
    }

    public void waitForStopped() {
        this.shardReplicaSets.parallelStream().forEach(OcpMongoReplicaSet::waitForStopped);
        this.configServerReplicaSet.waitForStopped();
        this.mongosRouter.waitForStopped();
    }

    public void removeShard() {
        int shardNum = this.shardReplicaSets.size() - 1;
        OcpMongoReplicaSet rs = this.shardReplicaSets.get(shardNum);
        LOGGER.info("Removing shard " + shardNum);
        this.shardKeys.forEach(k -> {
            List<ShardKeyRange> keyRanges = k.getKeyRanges().stream().filter(r -> r.getShardName().equals(rs.getName())).collect(Collectors.toList());
            keyRanges.forEach(r -> this.executeMongoSh(String.format("sh.removeRangeFromZone(\"%s\", {%s : %s}, {%s : %s})\n", k.getCollection(), k.getKey(), r.getStart(), k.getKey(), r.getEnd())));
        });
        this.executeMongoSh(String.format("sh.removeShardFromZone(\"%s\",\"%s\");", rs.getName(), rs.getName()));
        Awaitility.await().atMost(WaitConditions.scaled(20L), TimeUnit.MINUTES).pollInterval(20L, TimeUnit.SECONDS).until(() -> {
            OpenShiftUtils.CommandOutputs outputs = this.executeMongoSh(String.format("db.adminCommand( { removeShard: \"%s\" } )", rs.getName()));
            return outputs.getStdOut().contains("state: 'completed'");
        });
        rs.stop();
        this.shardReplicaSets.remove(rs);
    }

    public void addShard(@Nullable Map<MongoShardKey, ShardKeyRange> rangeMap) {
        int shardNum = this.shardReplicaSets.size();
        OcpMongoReplicaSet rs = this.deployNewShard(shardNum);
        this.registerShardInMongos(rangeMap, rs);
    }

    public String getConnectionString() {
        StringBuilder builder = new StringBuilder("mongodb://");
        if (StringUtils.isNotEmpty((CharSequence)this.rootUserName) && StringUtils.isNotEmpty((CharSequence)this.rootPassword)) {
            builder.append(this.rootUserName).append(":").append(this.rootPassword).append("@");
        }
        builder.append(this.mongosRouter.getHostname() + ":27017");
        return builder.toString();
    }

    public MongoShardKey getShardKey(String collection) {
        return this.shardKeys.stream().filter(s -> s.getCollection().equals(collection)).findFirst().get();
    }

    public OpenShiftUtils.CommandOutputs executeMongoSh(String command) {
        return MongoShardedUtil.executeMongoShOnPod(this.ocpUtils, this.project, this.mongosRouter.getDeployment(), this.getConnectionString(), command, false);
    }

    public List<MongoShardKey> getShardKeys() {
        return this.shardKeys;
    }

    public List<OcpMongoReplicaSet> getShardReplicaSets() {
        return this.shardReplicaSets;
    }

    public OcpMongoReplicaSet getConfigServerReplicaSet() {
        return this.configServerReplicaSet;
    }

    private void deployShards() {
        MongoShardedUtil.intRange(this.initialShardCount).parallelStream().forEach(this::deployNewShard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OcpMongoReplicaSet deployNewShard(int shardNum) {
        LOGGER.info("Deploying shard number " + shardNum);
        OcpMongoReplicaSet replicaSet = OcpMongoReplicaSet.builder().withShardNum(shardNum).withName(OcpShardModelProvider.getShardReplicaSetName(shardNum)).withConfigServer(false).withRootUserName(this.rootUserName).withRootPassword(this.rootPassword).withMemberCount(this.replicaCount).withUseInternalAuth(this.useInternalAuth).withOcp(this.ocp).withProject(this.project).build();
        replicaSet.start();
        List<OcpMongoReplicaSet> list = this.shardReplicaSets;
        synchronized (list) {
            this.shardReplicaSets.add(replicaSet);
        }
        return replicaSet;
    }

    private void registerShardInMongos(@Nullable Map<MongoShardKey, ShardKeyRange> rangeMap, OcpMongoReplicaSet rs) {
        StringBuilder command = new StringBuilder();
        command.append(this.addShardAndZoneInMongosCommand(rs));
        if (rangeMap != null) {
            rangeMap.forEach((k, z) -> command.append(this.addShardKeyRangeCommand((MongoShardKey)k, (ShardKeyRange)z)));
        }
        this.executeMongoSh(command.toString());
    }

    private void deployConfigServers() {
        OcpMongoReplicaSet replicaSet = OcpMongoReplicaSet.builder().withName("mongo-config").withConfigServer(true).withRootUserName(this.rootUserName).withRootPassword(this.rootPassword).withMemberCount(this.configServerCount).withUseInternalAuth(this.useInternalAuth).withOcp(this.ocp).withProject(this.project).build();
        replicaSet.start();
        this.configServerReplicaSet = replicaSet;
    }

    private void deployMongos() {
        this.mongosRouter = new OcpMongoDeploymentManager(OcpMongosModelProvider.mongosDeployment(this.configServerReplicaSet.getReplicaSetFullName()), OcpMongosModelProvider.mongosService(), null, this.ocp, this.project);
        if (this.useInternalAuth) {
            MongoShardedUtil.addKeyFileToDeployment(this.mongosRouter.getDeployment());
        }
        LOGGER.info("Deploying mongos");
        this.mongosRouter.start();
    }

    private void initMongos() throws IOException, TemplateException, InterruptedException {
        LOGGER.info("Initializing mongos...");
        Thread.sleep(5000L);
        StringBuilder command = new StringBuilder();
        this.shardReplicaSets.forEach(rs -> command.append(this.addShardAndZoneInMongosCommand((OcpMongoReplicaSet)rs)));
        command.append("sh.enableSharding(\"" + ConfigProperties.DATABASE_MONGO_DBZ_DBNAME + "\");\n");
        this.shardKeys.forEach(collection -> command.append(this.shardCollectionCommand((MongoShardKey)collection)));
        this.shardKeys.forEach(k -> k.getKeyRanges().forEach(z -> command.append(this.createKeyRangeCommand((ShardKeyRange)z, (MongoShardKey)k))));
        this.executeMongoSh(command.toString());
    }

    private String addShardKeyRangeCommand(MongoShardKey key, ShardKeyRange range) {
        Optional<MongoShardKey> keyMatch = this.shardKeys.stream().filter(k -> k.equals(key)).findFirst();
        if (keyMatch.isEmpty()) {
            throw new IllegalArgumentException("Illegal shard key");
        }
        keyMatch.get().getKeyRanges().add(range);
        return this.createKeyRangeCommand(range, key);
    }

    private String addShardAndZoneInMongosCommand(OcpMongoReplicaSet shardRs) {
        return "sh.addShard(\"" + shardRs.getReplicaSetFullName() + "\");\n sh.addShardToZone(\"" + shardRs.getName() + "\", \"" + shardRs.getName() + "\");\n";
    }

    private String shardCollectionCommand(MongoShardKey key) {
        return String.format("sh.shardCollection(\"%s\", { _id: %s } );\n", key.getCollection(), key.getShardingType().getValue());
    }

    private String createKeyRangeCommand(ShardKeyRange range, MongoShardKey key) {
        return String.format("sh.updateZoneKeyRange(\"%s\",{ %s : %s },{ %s : %s },\"%s\");\n", key.getCollection(), key.getKey(), range.getStart(), key.getKey(), range.getEnd(), range.getShardName());
    }

    public OcpMongoShardedCluster(int initialShardCount, int replicaCount, int configServerCount, @Nullable String rootUserName, @Nullable String rootPassword, boolean useInternalAuth, OpenShiftClient ocp, String project, List<MongoShardKey> shardKeys) {
        this.initialShardCount = initialShardCount;
        this.replicaCount = replicaCount;
        this.configServerCount = configServerCount;
        this.rootUserName = StringUtils.isNotEmpty((CharSequence)rootUserName) ? rootUserName : ConfigProperties.DATABASE_MONGO_USERNAME;
        this.rootPassword = StringUtils.isNotEmpty((CharSequence)rootPassword) ? rootPassword : ConfigProperties.DATABASE_MONGO_SA_PASSWORD;
        this.useInternalAuth = useInternalAuth;
        this.ocp = ocp;
        this.project = project;
        this.ocpUtils = new OpenShiftUtils(ocp);
        this.shardKeys = shardKeys;
    }

    public static OcpMongoShardedClusterBuilder builder() {
        return new OcpMongoShardedClusterBuilder();
    }

    public static final class OcpMongoShardedClusterBuilder {
        private int replicaCount;
        private int configServerCount;
        private String rootUserName;
        private String rootPassword;
        private boolean useInternalAuth;
        private OpenShiftClient ocp;
        private int initialShardCount;
        private String project;
        private List<MongoShardKey> shardKeys;

        private OcpMongoShardedClusterBuilder() {
        }

        public OcpMongoShardedClusterBuilder withReplicaCount(int replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public OcpMongoShardedClusterBuilder withConfigServerCount(int configServerCount) {
            this.configServerCount = configServerCount;
            return this;
        }

        public OcpMongoShardedClusterBuilder withRootUser(String rootUserName, String rootPassword) {
            this.rootUserName = rootUserName;
            this.rootPassword = rootPassword;
            return this;
        }

        public OcpMongoShardedClusterBuilder withUseInternalAuth(boolean useInternalAuth) {
            this.useInternalAuth = useInternalAuth;
            return this;
        }

        public OcpMongoShardedClusterBuilder withOcp(OpenShiftClient ocp) {
            this.ocp = ocp;
            return this;
        }

        public OcpMongoShardedClusterBuilder withInitialShardCount(int initialShardCount) {
            this.initialShardCount = initialShardCount;
            return this;
        }

        public OcpMongoShardedClusterBuilder withProject(String project) {
            this.project = project;
            return this;
        }

        public OcpMongoShardedClusterBuilder withShardKeys(List<MongoShardKey> shardKeys) {
            this.shardKeys = shardKeys;
            return this;
        }

        public OcpMongoShardedCluster build() {
            return new OcpMongoShardedCluster(this.initialShardCount, this.replicaCount, this.configServerCount, this.rootUserName, this.rootPassword, this.useInternalAuth, this.ocp, this.project, this.shardKeys);
        }
    }
}

