/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tests.mongodb.sharded;

import com.mongodb.client.model.Filters;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.tests.ConnectorTest;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseClient;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.OcpMongoShardedController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import java.io.IOException;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class ShardedMongoTests
extends ConnectorTest {
    public ShardedMongoTests(KafkaController kafkaController, KafkaConnectController connectController, ConnectorConfigBuilder connectorConfig, KafkaAssertions<?, ?> assertions) {
        super(kafkaController, connectController, connectorConfig, assertions);
    }

    public void insertCustomer(MongoDatabaseController dbController, String firstName, String lastName, String email, long id) {
        MongoDatabaseClient client = dbController.getDatabaseClient(ConfigProperties.DATABASE_MONGO_DBZ_USERNAME, ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD, ConfigProperties.DATABASE_MONGO_DBZ_LOGIN_DBNAME);
        client.execute(ConfigProperties.DATABASE_MONGO_DBZ_DBNAME, "customers", col -> {
            Document doc = new Document().append("_id", (Object)id).append("first_name", (Object)firstName).append("last_name", (Object)lastName).append("email", (Object)email);
            col.insertOne((Object)doc);
        });
    }

    public void removeCustomer(MongoDatabaseController dbController, String email) {
        MongoDatabaseClient client = dbController.getDatabaseClient(ConfigProperties.DATABASE_MONGO_DBZ_USERNAME, ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD, ConfigProperties.DATABASE_MONGO_DBZ_LOGIN_DBNAME);
        client.execute("inventory", "customers", col -> {
            Bson query = Filters.eq((String)"email", (Object)email);
            col.deleteOne((Bson)col.find(query).first());
        });
    }

    public void insertProduct(MongoDatabaseController dbController, String name, String description, String weight, int quantity) {
        MongoDatabaseClient client = dbController.getDatabaseClient(ConfigProperties.DATABASE_MONGO_DBZ_USERNAME, ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD, ConfigProperties.DATABASE_MONGO_DBZ_LOGIN_DBNAME);
        client.execute(ConfigProperties.DATABASE_MONGO_DBZ_DBNAME, "products", col -> {
            Document doc = new Document().append("name", (Object)name).append("description", (Object)description).append("weight", (Object)weight).append("quantity", (Object)quantity);
            col.insertOne((Object)doc);
        });
    }

    protected void addAndRemoveShardTest(OcpMongoShardedController dbController, String connectorName) throws IOException, InterruptedException {
        String topic = connectorName + ".inventory.customers";
        int rangeStart = 1100;
        int rangeEnd = 1105;
        dbController.addShard(3, "THREE", rangeStart, rangeEnd);
        this.connectController.undeployConnector(connectorName);
        this.connectController.deployConnector(this.connectorConfig);
        this.insertCustomer((MongoDatabaseController)dbController, "Filip", "Foobar", "ffoo@test.com", 1101L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "ffoo@test.com"));
        this.removeCustomer((MongoDatabaseController)dbController, "ffoo@test.com");
        dbController.removeShard(3, rangeStart, rangeEnd);
        this.connectController.undeployConnector(connectorName);
        this.connectController.deployConnector(this.connectorConfig);
    }
}

