/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tests.mongodb.sharded;

import fixture5.FixtureExtension;
import fixture5.annotations.Fixture;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.fixtures.OcpClient;
import io.debezium.testing.system.fixtures.connectors.ShardedMongoConnector;
import io.debezium.testing.system.fixtures.databases.ocp.OcpMongoSharded;
import io.debezium.testing.system.fixtures.kafka.OcpKafka;
import io.debezium.testing.system.fixtures.operator.OcpStrimziOperator;
import io.debezium.testing.system.tests.mongodb.sharded.ShardedMongoTests;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.OcpMongoShardedController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import java.io.IOException;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Tags(value={@Tag(value="acceptance"), @Tag(value="mongo"), @Tag(value="openshift"), @Tag(value="mongo-sharded")})
@Fixture.Container(value={@Fixture(value=OcpClient.class), @Fixture(value=OcpStrimziOperator.class), @Fixture(value=OcpKafka.class), @Fixture(value=OcpMongoSharded.class), @Fixture(value=ShardedMongoConnector.class)})
@ExtendWith(value={FixtureExtension.class})
public class OcpShardedMongoConnectorIT
extends ShardedMongoTests {
    public OcpShardedMongoConnectorIT(KafkaController kafkaController, KafkaConnectController connectController, ConnectorConfigBuilder connectorConfig, KafkaAssertions<?, ?> assertions) {
        super(kafkaController, connectController, connectorConfig, assertions);
    }

    @Test
    public void shouldStreamInShardedMode(OcpMongoShardedController dbController) throws IOException, InterruptedException {
        this.insertCustomer((MongoDatabaseController)dbController, "Adam", "Sharded", "ashard@test.com", 1005L);
        String topic = this.connectorConfig.getConnectorName() + ".inventory.customers";
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "ashard@test.com"));
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsCount(topic, 5));
        this.insertProduct((MongoDatabaseController)dbController, "sharded product", "demonstrates, that sharded connector mode works", "12.5", 3);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(this.connectorConfig.getConnectorName() + ".inventory.products", "sharded product"));
        this.addAndRemoveShardTest(dbController, this.connectorConfig.getConnectorName());
        this.insertCustomer((MongoDatabaseController)dbController, "David", "Duck", "duck@test.com", 1006L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "duck@test.com"));
    }
}

