/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.builders;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.fabric8.FabricBuilderWrapper;
import io.fabric8.kubernetes.api.model.Secret;
import io.strimzi.api.kafka.model.EntityOperatorSpec;
import io.strimzi.api.kafka.model.EntityOperatorSpecBuilder;
import io.strimzi.api.kafka.model.EntityOperatorSpecFluent;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpec;
import io.strimzi.api.kafka.model.EntityUserOperatorSpec;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBuilder;
import io.strimzi.api.kafka.model.KafkaClusterSpec;
import io.strimzi.api.kafka.model.KafkaClusterSpecBuilder;
import io.strimzi.api.kafka.model.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.ZookeeperClusterSpec;
import io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder;
import io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import io.strimzi.api.kafka.model.storage.Storage;
import io.strimzi.api.kafka.model.template.PodTemplate;
import io.strimzi.api.kafka.model.template.PodTemplateBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class FabricKafkaBuilder
extends FabricBuilderWrapper<FabricKafkaBuilder, KafkaBuilder, Kafka> {
    public static String DEFAULT_KAFKA_NAME = "debezium-kafka-cluster";

    private FabricKafkaBuilder(KafkaBuilder kafkaBuilder) {
        super(kafkaBuilder);
    }

    @Override
    public Kafka build() {
        return ((KafkaBuilder)this.builder).build();
    }

    public static FabricKafkaBuilder base() {
        KafkaClusterSpec kafka = FabricKafkaBuilder.defaultKafkaSpec();
        ZookeeperClusterSpec zookeeper = FabricKafkaBuilder.defaultKafkaZookeeperSpec();
        EntityOperatorSpec entityOperator = FabricKafkaBuilder.defaultKafkaEntityOperatorSpec();
        KafkaBuilder builder = (KafkaBuilder)((KafkaFluent.SpecNested)((KafkaFluent.SpecNested)((KafkaFluent.SpecNested)((KafkaBuilder)((KafkaFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName(DEFAULT_KAFKA_NAME)).endMetadata()).withNewSpec().withKafka(kafka)).withZookeeper(zookeeper)).withEntityOperator(entityOperator)).endSpec();
        return new FabricKafkaBuilder(builder);
    }

    public FabricKafkaBuilder withPullSecret(Optional<Secret> maybePullSecret) {
        maybePullSecret.map(s -> s.getMetadata().getName()).ifPresent(this::withPullSecret);
        return (FabricKafkaBuilder)this.self();
    }

    public FabricKafkaBuilder withPullSecret(String pullSecretName) {
        PodTemplate podTemplate = ((PodTemplateBuilder)new PodTemplateBuilder().addNewImagePullSecret(pullSecretName)).build();
        ((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((EntityOperatorSpecFluent.TemplateNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((ZookeeperClusterSpecFluent.TemplateNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaClusterSpecFluent.TemplateNested)((KafkaBuilder)this.builder).editSpec().editKafka().withNewTemplate().withPod(podTemplate)).endTemplate()).endKafka()).editZookeeper().withNewTemplate().withPod(podTemplate)).endTemplate()).endZookeeper()).editEntityOperator().withNewTemplate().withPod(podTemplate)).endTemplate()).endEntityOperator()).endSpec();
        return (FabricKafkaBuilder)this.self();
    }

    private static KafkaClusterSpec defaultKafkaSpec() {
        Map<String, Object> config = FabricKafkaBuilder.defaultKafkaConfig();
        List<GenericKafkaListener> listeners = FabricKafkaBuilder.defaultKafkaListeners();
        return ((KafkaClusterSpecBuilder)((KafkaClusterSpecBuilder)((KafkaClusterSpecBuilder)((KafkaClusterSpecBuilder)((KafkaClusterSpecBuilder)new KafkaClusterSpecBuilder().withConfig(config)).withReplicas(3)).withVersion(ConfigProperties.STRIMZI_VERSION_KAFKA)).withListeners(listeners)).withStorage((Storage)new EphemeralStorage())).build();
    }

    private static List<GenericKafkaListener> defaultKafkaListeners() {
        GenericKafkaListener plainInternal = ((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("plain")).withPort(9092)).withType(KafkaListenerType.INTERNAL)).build();
        GenericKafkaListener tlsInternal = ((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("tls")).withPort(9093)).withType(KafkaListenerType.INTERNAL)).withTls(true)).build();
        GenericKafkaListener routeExternal = ((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("external")).withPort(9094)).withType(KafkaListenerType.ROUTE)).withTls(true)).build();
        return Arrays.asList(plainInternal, tlsInternal, routeExternal);
    }

    private static Map<String, Object> defaultKafkaConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("offsets.topic.replication.factor", 1);
        config.put("transaction.state.log.replication.factor", 1);
        config.put("transaction.state.log.min.isr", 1);
        return config;
    }

    private static ZookeeperClusterSpec defaultKafkaZookeeperSpec() {
        return ((ZookeeperClusterSpecBuilder)((ZookeeperClusterSpecBuilder)new ZookeeperClusterSpecBuilder().withStorage((SingleVolumeStorage)new EphemeralStorage())).withReplicas(1)).build();
    }

    private static EntityOperatorSpec defaultKafkaEntityOperatorSpec() {
        EntityTopicOperatorSpec topicOperator = new EntityTopicOperatorSpec();
        EntityUserOperatorSpec userOperator = new EntityUserOperatorSpec();
        return ((EntityOperatorSpecBuilder)((EntityOperatorSpecBuilder)new EntityOperatorSpecBuilder().withTopicOperator(topicOperator)).withUserOperator(userOperator)).build();
    }
}

