/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tests.mongodb;

import io.debezium.testing.system.TestUtils;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.resources.ConnectorFactories;
import io.debezium.testing.system.tests.mongodb.MongoTests;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.OcpMongoShardedController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import java.io.IOException;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

public abstract class OcpMongoTests
extends MongoTests {
    public OcpMongoTests(KafkaController kafkaController, KafkaConnectController connectController, ConnectorConfigBuilder connectorConfig, KafkaAssertions<?, ?> assertions) {
        super(kafkaController, connectController, connectorConfig, assertions);
    }

    private void addAndRemoveShardTest(OcpMongoShardedController dbController, String connectorName) throws IOException, InterruptedException {
        String topic = connectorName + ".inventory.customers";
        int rangeStart = 1100;
        int rangeEnd = 1105;
        dbController.addShard(3, "THREE", rangeStart, rangeEnd);
        this.connectController.undeployConnector(connectorName);
        this.connectController.deployConnector(this.connectorConfig);
        this.insertCustomer((MongoDatabaseController)dbController, "Filip", "Foobar", "ffoo@test.com", 1101L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "ffoo@test.com"));
        this.removeCustomer((MongoDatabaseController)dbController, "ffoo@test.com");
        dbController.removeShard(3, rangeStart, rangeEnd);
        this.connectController.undeployConnector(connectorName);
        this.connectController.deployConnector(this.connectorConfig);
    }

    @Test
    @Order(value=100)
    public void shouldStreamInShardedMode(OcpMongoShardedController dbController) throws IOException, InterruptedException {
        this.connectController.undeployConnector(this.connectorConfig.getConnectorName());
        String connectorName = "sharded-connector" + TestUtils.getUniqueId();
        this.connectorConfig = new ConnectorFactories(this.kafkaController).mongo((MongoDatabaseController)dbController, connectorName).put("mongodb.connection.string", (Object)("mongodb://" + dbController.getDatabaseHostname() + ":" + dbController.getDatabasePort())).put("mongodb.connection.mode", (Object)"sharded").put("topic.prefix", (Object)connectorName);
        this.connectController.deployConnector(this.connectorConfig);
        this.insertCustomer((MongoDatabaseController)dbController, "Adam", "Sharded", "ashard@test.com", 1005L);
        String topic = connectorName + ".inventory.customers";
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "ashard@test.com"));
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsCount(topic, 5));
        this.insertProduct((MongoDatabaseController)dbController, "sharded product", "demonstrates, that sharded connector mode works", "12.5", 3);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(connectorName + ".inventory.products", "sharded product"));
        this.addAndRemoveShardTest(dbController, connectorName);
        this.insertCustomer((MongoDatabaseController)dbController, "David", "Duck", "duck@test.com", 1006L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "duck@test.com"));
        this.connectController.undeployConnector(this.connectorConfig.getConnectorName());
    }

    @Test
    @Order(value=110)
    public void shouldStreamInReplicaSetMode(OcpMongoShardedController dbController) throws IOException, InterruptedException {
        String connectorName = "replicaset-connector" + TestUtils.getUniqueId();
        this.connectorConfig = new ConnectorFactories(this.kafkaController).mongo((MongoDatabaseController)dbController, connectorName).put("mongodb.connection.string", (Object)("mongodb://" + dbController.getDatabaseHostname() + ":" + dbController.getDatabasePort())).put("mongodb.connection.mode", (Object)"replica_set").put("task.max", (Object)4).put("topic.prefix", (Object)connectorName);
        this.connectController.deployConnector(this.connectorConfig);
        String topic = connectorName + ".inventory.customers";
        this.assertions.assertTopicsExist(connectorName + ".inventory.customers");
        this.insertCustomer((MongoDatabaseController)dbController, "Eve", "Sharded", "eshard@test.com", 1007L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "eshard@test.com"));
        KafkaAssertions.awaitAssert(() -> this.assertions.assertMinimalRecordsCount(topic, 7));
        this.insertProduct((MongoDatabaseController)dbController, "replicaset product", "demonstrates that replicaset connector mode works", "12.5", 3);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(connectorName + ".inventory.products", "replicaset product"));
        this.addAndRemoveShardTest(dbController, connectorName);
        this.insertCustomer((MongoDatabaseController)dbController, "Eric", "Eh", "ee@test.com", 1008L);
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "ee@test.com"));
        this.connectController.undeployConnector(connectorName);
    }
}

