/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.operator;

import fixture5.TestFixture;
import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorDeployer;
import io.debezium.testing.system.tools.operatorutil.OpenshiftOperatorEnum;
import io.fabric8.openshift.client.OpenShiftClient;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixtureContext(requires={OpenShiftClient.class}, provides={StrimziOperatorController.class})
public class OcpStrimziOperator
extends TestFixture {
    private final OpenShiftClient ocp = (OpenShiftClient)this.retrieve(OpenShiftClient.class);
    private final String project = ConfigProperties.OCP_PROJECT_DBZ;
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpStrimziOperator.class);

    public OcpStrimziOperator(@NotNull ExtensionContext.Store store) {
        super(store);
    }

    public void setup() throws Exception {
        StrimziOperatorController operatorController;
        if (ConfigProperties.PREPARE_NAMESPACES_AND_STRIMZI) {
            operatorController = new StrimziOperatorDeployer(this.project, this.ocp, null).deploy();
            operatorController.waitForAvailable();
        } else {
            LOGGER.info("Skipping " + OpenshiftOperatorEnum.STRIMZI.getName() + " deployment");
        }
        operatorController = StrimziOperatorController.forProject((String)this.project, (OpenShiftClient)this.ocp);
        this.updateStrimziOperator(operatorController);
        this.store(StrimziOperatorController.class, operatorController);
    }

    public void teardown() {
        LOGGER.debug("Skipping " + OpenshiftOperatorEnum.STRIMZI.getName() + " operator tear down");
    }

    private void updateStrimziOperator(StrimziOperatorController operatorController) {
        operatorController.setLogLevel("DEBUG");
        operatorController.setAlwaysPullPolicy();
        operatorController.setOperandAlwaysPullPolicy();
        operatorController.setSingleReplica();
        ConfigProperties.OCP_PULL_SECRET_PATH.ifPresent(arg_0 -> ((StrimziOperatorController)operatorController).deployPullSecret(arg_0));
        operatorController.updateOperator();
    }
}

