/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.kafka;

import fixture5.TestFixture;
import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.assertions.PlainKafkaAssertions;
import io.debezium.testing.system.tools.kafka.DockerKafkaConnectController;
import io.debezium.testing.system.tools.kafka.DockerKafkaConnectDeployer;
import io.debezium.testing.system.tools.kafka.DockerKafkaController;
import io.debezium.testing.system.tools.kafka.DockerKafkaDeployer;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.Network;

@FixtureContext(requires={Network.class}, provides={KafkaController.class, KafkaConnectController.class, KafkaAssertions.class})
public class DockerKafka
extends TestFixture {
    private final Network network = (Network)this.retrieve(Network.class);
    private DockerKafkaController kafkaController;
    private DockerKafkaConnectController connectController;

    public DockerKafka(@NotNull ExtensionContext.Store store) {
        super(store);
    }

    public void setup() {
        DockerKafkaDeployer kafkaDeployer = ((DockerKafkaDeployer.Builder)new DockerKafkaDeployer.Builder().withNetwork(this.network)).build();
        this.kafkaController = kafkaDeployer.deploy();
        DockerKafkaConnectDeployer connectDeployer = new DockerKafkaConnectDeployer.Builder().withKafka(this.kafkaController).build();
        this.connectController = (DockerKafkaConnectController)connectDeployer.deploy();
        this.store(KafkaController.class, this.kafkaController);
        this.store(KafkaConnectController.class, this.connectController);
        this.store(KafkaAssertions.class, new PlainKafkaAssertions(this.kafkaController.getDefaultConsumerProperties()));
    }

    public void teardown() {
        if (this.kafkaController != null) {
            this.kafkaController.undeploy();
        }
        if (this.connectController != null) {
            this.connectController.undeploy();
        }
    }
}

