/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.connectors;

import fixture5.TestFixture;
import io.debezium.testing.system.TestUtils;
import io.debezium.testing.system.tools.databases.DatabaseController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.registry.RegistryController;
import java.io.IOException;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class ConnectorFixture<T extends DatabaseController<?>>
extends TestFixture {
    private static final String CONNECTOR_NAME = "inventory-connector-mysql";
    protected final KafkaController kafkaController;
    protected final KafkaConnectController connectController;
    protected final RegistryController apicurioController;
    protected final Class<T> controllerType;
    protected final T dbController;
    protected final String connectorBaseName;
    protected ConnectorConfigBuilder connectorConfig;

    public ConnectorFixture(String connectorName, Class<T> controllerType, ExtensionContext.Store store) {
        super(store);
        this.connectorBaseName = connectorName;
        this.controllerType = controllerType;
        this.kafkaController = (KafkaController)this.retrieve(KafkaController.class);
        this.connectController = (KafkaConnectController)this.retrieve(KafkaConnectController.class);
        this.dbController = (DatabaseController)this.retrieve(controllerType);
        this.apicurioController = (RegistryController)this.retrieve(RegistryController.class);
    }

    protected abstract ConnectorConfigBuilder connectorConfig(String var1);

    public void setup() throws Exception {
        String connectorName = this.connectorBaseName + TestUtils.getUniqueId();
        this.connectorConfig = this.connectorConfig(connectorName);
        if (this.apicurioController != null) {
            this.connectorConfig.addApicurioAvroSupport(this.apicurioController.getRegistryApiAddress());
        }
        this.connectController.deployConnector(this.connectorConfig);
        this.store(ConnectorConfigBuilder.class, this.connectorConfig);
    }

    public void teardown() throws IOException {
        if (this.connectorConfig != null) {
            this.connectController.undeployConnector(this.connectorConfig.getConnectorName());
        }
    }
}

