/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tests.mysql;

import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.tests.mysql.MySqlTests;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.SqlDatabaseController;
import io.debezium.testing.system.tools.databases.mysql.MySqlController;
import io.debezium.testing.system.tools.databases.mysql.MySqlReplicaController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import java.io.IOException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

public abstract class MySqlOcpTests
extends MySqlTests {
    public MySqlOcpTests(KafkaController kafkaController, KafkaConnectController connectController, ConnectorConfigBuilder connectorConfig, KafkaAssertions<?, ?> assertions) {
        super(kafkaController, connectController, connectorConfig, assertions);
    }

    @Test
    @Order(value=100)
    public void shouldStreamFromReplica(MySqlReplicaController replicaController, MySqlController masterController) throws InterruptedException, IOException, SQLException {
        Awaitility.await().atMost(WaitConditions.scaled((long)5L), TimeUnit.MINUTES).pollInterval(Duration.ofSeconds(20L)).until(() -> Objects.equals(this.getCustomerCount((SqlDatabaseController)replicaController), this.getCustomerCount((SqlDatabaseController)masterController)));
        this.connectorConfig.put("database.hostname", (Object)replicaController.getDatabaseHostname());
        this.connectController.deployConnector(this.connectorConfig);
        this.insertCustomer((SqlDatabaseController)masterController, "Arnold", "Test", "atest@test.com");
        String topic = this.connectorConfig.getDbServerName() + ".inventory.customers";
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsCount(topic, 8));
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "atest@test.com"));
    }

    @Test
    @Order(value=110)
    public void shouldStreamAfterMasterRestart(MySqlReplicaController replicaController, MySqlController masterController) throws SQLException, IOException, InterruptedException {
        this.connectorConfig.put("database.hostname", (Object)masterController.getDatabaseHostname());
        this.connectController.deployConnector(this.connectorConfig);
        this.insertCustomer((SqlDatabaseController)masterController, "Alex", "master", "amaster@test.com");
        String topic = this.connectorConfig.getDbServerName() + ".inventory.customers";
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsCount(topic, 9));
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "amaster@test.com"));
        Awaitility.await().atMost(WaitConditions.scaled((long)5L), TimeUnit.MINUTES).pollInterval(Duration.ofSeconds(20L)).until(() -> Objects.equals(this.getCustomerCount((SqlDatabaseController)replicaController), this.getCustomerCount((SqlDatabaseController)masterController)));
        masterController.reload();
        this.connectorConfig.put("database.hostname", (Object)replicaController.getDatabaseHostname());
        this.connectController.deployConnector(this.connectorConfig);
        this.insertCustomer((SqlDatabaseController)masterController, "Tom", "Train", "ttrain@test.com");
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsCount(topic, 10));
        KafkaAssertions.awaitAssert(() -> this.assertions.assertRecordsContain(topic, "ttrain@test.com"));
    }
}

