/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases;

import io.debezium.testing.system.tools.databases.DatabaseClient;
import io.debezium.testing.system.tools.databases.DatabaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public abstract class AbstractDockerDatabaseController<T extends GenericContainer<?>, C extends DatabaseClient<?, ?>>
implements DatabaseController<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDockerDatabaseController.class);
    protected final T container;

    public AbstractDockerDatabaseController(T container) {
        this.container = container;
    }

    @Override
    public String getPublicDatabaseHostname() {
        return this.container.getHost();
    }

    @Override
    public int getPublicDatabasePort() {
        return this.container.getMappedPort(this.getDatabasePort());
    }

    @Override
    public String getDatabaseHostname() {
        return (String)this.container.getNetworkAliases().get(0);
    }

    @Override
    public void reload() {
        this.container.stop();
        this.container.start();
    }
}

