/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.listeners;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespacePreparationListener
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespacePreparationListener.class);
    private OpenShiftClient client;
    private List<String> projectNames;

    public void testPlanExecutionStarted(TestPlan testPlan) {
        if (ConfigProperties.OCP_PROJECT_DBZ != null) {
            this.projectNames = List.of(ConfigProperties.OCP_PROJECT_DBZ, ConfigProperties.OCP_PROJECT_ORACLE, ConfigProperties.OCP_PROJECT_MONGO, ConfigProperties.OCP_PROJECT_DB2, ConfigProperties.OCP_PROJECT_MYSQL, ConfigProperties.OCP_PROJECT_POSTGRESQL, ConfigProperties.OCP_PROJECT_REGISTRY, ConfigProperties.OCP_PROJECT_SQLSERVER);
            this.client = OpenShiftUtils.createOcpClient();
            this.validateSystemParameters();
            this.prepareNamespaces();
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (ConfigProperties.OCP_PROJECT_DBZ != null) {
            LOGGER.info("Cleaning namespaces");
            this.projectNames.forEach(name -> {
                Project project = (Project)((Resource)this.client.projects().withName(name)).get();
                if (project != null) {
                    this.client.projects().delete((Object[])new Project[]{project});
                }
            });
            this.client.close();
        }
    }

    private void prepareNamespaces() {
        LOGGER.info("Preparing namespaces");
        ClusterRoleBindingBuilder anyUidBindingBuilder = (ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)new ClusterRoleBindingBuilder().withApiVersion("authorization.openshift.io/v1")).withKind("ClusterRoleBinding")).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName("system:openshift:scc:anyuid")).build())).withRoleRef(((ObjectReferenceBuilder)new ObjectReferenceBuilder().withName("system:openshift:scc:anyuid")).build());
        ClusterRoleBindingBuilder privilegedBindingBuilder = (ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)new ClusterRoleBindingBuilder().withApiVersion("authorization.openshift.io/v1")).withKind("ClusterRoleBinding")).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName("system:openshift:scc:privileged")).build())).withRoleRef(((ObjectReferenceBuilder)new ObjectReferenceBuilder().withName("system:openshift:scc:privileged")).build());
        for (String project : this.projectNames) {
            this.processNamespace(project, anyUidBindingBuilder, privilegedBindingBuilder);
        }
        this.waitForDefaultServiceAccount();
        this.client.clusterRoleBindings().createOrReplace((Object[])new ClusterRoleBinding[]{anyUidBindingBuilder.build()});
        this.client.clusterRoleBindings().createOrReplace((Object[])new ClusterRoleBinding[]{privilegedBindingBuilder.build()});
    }

    private void waitForDefaultServiceAccount() {
        this.projectNames.forEach(name -> Awaitility.await().atMost(WaitConditions.scaled((long)1L), TimeUnit.MINUTES).pollInterval(1L, TimeUnit.SECONDS).until(() -> ((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(name)).withName("default")).get() != null));
    }

    private void processNamespace(String namespace, ClusterRoleBindingBuilder anyuidBuilder, ClusterRoleBindingBuilder privilegedBuilder) {
        if (((Resource)this.client.projects().withName(namespace)).get() == null) {
            this.client.projects().createOrReplace((Object[])new Project[]{((ProjectBuilder)((ProjectBuilder)((ProjectBuilder)new ProjectBuilder().withKind("Project")).withApiVersion("project.openshift.io/v1")).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(namespace)).build())).build()});
        }
        this.addServiceAccountToClusterRoleBinding(namespace, anyuidBuilder);
        this.addServiceAccountToClusterRoleBinding(namespace, privilegedBuilder);
    }

    private void addServiceAccountToClusterRoleBinding(String saNamespace, ClusterRoleBindingBuilder bindingBuilder) {
        bindingBuilder.addNewSubjectLike(((ObjectReferenceBuilder)((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("SystemUser")).withName("default")).withNamespace(saNamespace)).build());
        bindingBuilder.addNewUserName("system:serviceaccount:" + saNamespace + ":default");
    }

    private void validateSystemParameters() {
        if (ConfigProperties.PREPARE_NAMESPACES_AND_STRIMZI && this.namespacesExist()) {
            LOGGER.warn("Should prepare strimzi operator, but namespaces exist. Using existing namespaces");
        }
        if (!ConfigProperties.PREPARE_NAMESPACES_AND_STRIMZI && !ConfigProperties.PRODUCT_BUILD) {
            throw new IllegalStateException("PREPARE_STRIMZI is false in upstream build");
        }
        if (!ConfigProperties.PREPARE_NAMESPACES_AND_STRIMZI && !this.namespacesExist()) {
            throw new IllegalStateException("should not prepare strimzi/namespace but namespace is missing");
        }
    }

    private boolean namespacesExist() {
        Assertions.assertThat(this.projectNames).isNotEmpty();
        Assertions.assertThat((Object)this.client).isNotNull();
        return ((Resource)this.client.projects().withName(this.projectNames.get(0))).get() != null;
    }
}

