/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.kafka;

import fixture5.TestFixture;
import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.assertions.PlainKafkaAssertions;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.artifacts.OcpArtifactServerController;
import io.debezium.testing.system.tools.artifacts.OcpArtifactServerDeployer;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectController;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectDeployer;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.debezium.testing.system.tools.kafka.OcpKafkaDeployer;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.debezium.testing.system.tools.kafka.builders.FabricKafkaBuilder;
import io.debezium.testing.system.tools.kafka.builders.FabricKafkaConnectBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixtureContext(requires={OpenShiftClient.class, StrimziOperatorController.class}, provides={KafkaController.class, KafkaConnectController.class, KafkaAssertions.class})
public class OcpKafka
extends TestFixture {
    private final OpenShiftClient ocp = (OpenShiftClient)this.retrieve(OpenShiftClient.class);
    private final String project = ConfigProperties.OCP_PROJECT_DBZ;
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafka.class);
    String KAFKA_CONNECT_LOGGING = "/kafka-resources/020-kafka-connect-cfg.yaml";
    String ARTIFACT_SERVER_DEPLOYMENT = "/artifact-server/010-deployment.yaml";
    String ARTIFACT_SERVER_SERVICE = "/artifact-server/020-service.yaml";

    public OcpKafka(@NotNull ExtensionContext.Store store) {
        super(store);
    }

    public void setup() throws Exception {
        StrimziOperatorController operatorController = (StrimziOperatorController)this.retrieve(StrimziOperatorController.class);
        if (operatorController == null) {
            throw new IllegalStateException("Strimzi operator controller is null");
        }
        OcpKafkaController kafkaController = this.deployKafkaCluster(operatorController);
        this.deployConnectCluster(operatorController, kafkaController);
    }

    public void teardown() {
        LOGGER.debug("Skipping kafka tear down");
    }

    private OcpKafkaController deployKafkaCluster(StrimziOperatorController operatorController) throws Exception {
        FabricKafkaBuilder builder = FabricKafkaBuilder.base().withPullSecret(operatorController.getPullSecret());
        OcpKafkaDeployer kafkaDeployer = new OcpKafkaDeployer(this.project, builder, operatorController, this.ocp, new OkHttpClient());
        OcpKafkaController controller = kafkaDeployer.deploy();
        this.store(KafkaController.class, controller);
        this.store(KafkaAssertions.class, new PlainKafkaAssertions(controller.getDefaultConsumerProperties()));
        return controller;
    }

    private void deployConnectCluster(StrimziOperatorController operatorController, OcpKafkaController kafkaController) throws Exception {
        ConfigMap configMap = (ConfigMap)YAML.fromResource((String)this.KAFKA_CONNECT_LOGGING, ConfigMap.class);
        FabricKafkaConnectBuilder builder = FabricKafkaConnectBuilder.base((String)kafkaController.getLocalBootstrapAddress()).withLoggingFromConfigMap(configMap).withMetricsFromConfigMap(configMap).withConnectorResources(Boolean.valueOf(ConfigProperties.STRIMZI_OPERATOR_CONNECTORS));
        if (ConfigProperties.STRIMZI_KC_BUILD) {
            OcpArtifactServerController artifactServerController = this.deployArtifactServer();
            builder.withBuild(artifactServerController);
        } else {
            builder.withImage(ConfigProperties.STRIMZI_KC_IMAGE);
        }
        builder.withPullSecret(operatorController.getPullSecret());
        OcpKafkaConnectDeployer connectDeployer = new OcpKafkaConnectDeployer(this.project, builder, configMap, operatorController, this.ocp, new OkHttpClient());
        OcpKafkaConnectController controller = connectDeployer.deploy();
        controller.allowServiceAccess();
        controller.exposeApi();
        controller.exposeMetrics();
        this.store(KafkaConnectController.class, controller);
    }

    private OcpArtifactServerController deployArtifactServer() throws Exception {
        OcpArtifactServerDeployer deployer = new OcpArtifactServerDeployer.Builder().withOcpClient(this.ocp).withHttpClient(new OkHttpClient()).withProject(this.project).withDeployment(this.ARTIFACT_SERVER_DEPLOYMENT).withService(this.ARTIFACT_SERVER_SERVICE).build();
        return deployer.deploy();
    }
}

