/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools;

import io.debezium.testing.system.tools.Deployer;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerImageName;

public abstract class AbstractDockerDeployer<T, C extends GenericContainer<?>>
implements Deployer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDockerDeployer.class);
    protected final C container;

    public AbstractDockerDeployer(C container) {
        this.container = container;
    }

    protected abstract T getController(C var1);

    protected Logger getCurrentLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public T deploy() {
        Startables.deepStart(Stream.of(this.container)).join();
        this.container.followOutput((Consumer)new Slf4jLogConsumer(this.getCurrentLogger()));
        return this.getController(this.container);
    }

    public static abstract class DockerBuilder<B extends DockerBuilder<B, C, D>, C extends GenericContainer<?>, D extends AbstractDockerDeployer<?, C>>
    implements Deployer.Builder<B, D> {
        protected C container;

        public DockerBuilder(C container) {
            Objects.requireNonNull(container, "Missing container");
            this.container = container;
        }

        protected static DockerImageName image(String fullImageName, String substituteFor) {
            return DockerImageName.parse((String)fullImageName).asCompatibleSubstituteFor(substituteFor);
        }

        public B withNetwork(Network network) {
            this.container.withNetwork(network);
            return (B)((DockerBuilder)this.self());
        }

        public B withContainerConfig(Consumer<C> config) {
            config.accept(this.container);
            return (B)((DockerBuilder)this.self());
        }
    }
}

