/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.registry;

import fixture5.TestFixture;
import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.assertions.AvroKafkaAssertions;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.registry.ApicurioOperatorController;
import io.debezium.testing.system.tools.registry.OcpApicurioController;
import io.debezium.testing.system.tools.registry.OcpApicurioDeployer;
import io.debezium.testing.system.tools.registry.RegistryController;
import io.debezium.testing.system.tools.registry.builders.FabricApicurioBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixtureContext(requires={OpenShiftClient.class, KafkaController.class, ApicurioOperatorController.class}, provides={RegistryController.class}, overrides={KafkaAssertions.class})
public class OcpApicurio
extends TestFixture {
    private final OpenShiftClient ocp = (OpenShiftClient)this.retrieve(OpenShiftClient.class);
    private final KafkaController kafkaController = (KafkaController)this.retrieve(KafkaController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurio.class);

    public OcpApicurio(@NotNull ExtensionContext.Store store) {
        super(store);
    }

    public void setup() throws Exception {
        FabricApicurioBuilder fabricBuilder = FabricApicurioBuilder.baseKafkaSql((String)this.kafkaController.getBootstrapAddress());
        OcpApicurioDeployer deployer = new OcpApicurioDeployer(ConfigProperties.OCP_PROJECT_REGISTRY, fabricBuilder, this.ocp, new OkHttpClient());
        OcpApicurioController controller = deployer.deploy();
        this.store(RegistryController.class, controller);
        this.store(KafkaAssertions.class, new AvroKafkaAssertions(this.kafkaController.getDefaultConsumerProperties()));
    }

    public void teardown() {
        LOGGER.debug("Skipping apicurio tear down");
    }
}

