/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.OperatorController;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrimziOperatorController
extends OperatorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaController.class);
    private static final String DEPLOYMENT_PREFIX = "strimzi-cluster-operator";
    private static final String DEPLOYMENT_PREFIX_OLM = "amq-streams-cluster-operator";
    private static final Map<String, String> OPERATOR_LABELS = Map.of("strimzi.io/kind", "cluster-operator");

    public static StrimziOperatorController forProject(String project, OpenShiftClient ocp) {
        LOGGER.info("Looking for Strimzi operator");
        OpenShiftUtils ocpUtils = new OpenShiftUtils(ocp);
        Optional<Deployment> operator = ocpUtils.deploymentsWithPrefix(project, DEPLOYMENT_PREFIX, DEPLOYMENT_PREFIX_OLM);
        return new StrimziOperatorController(operator.orElseThrow(), ocp);
    }

    private StrimziOperatorController(Deployment operator, OpenShiftClient ocp) {
        super(operator, OPERATOR_LABELS, ocp);
    }

    public void setOperandImagePullSecrets(String names) {
        this.setEnvVar("STRIMZI_IMAGE_PULL_SECRETS", names);
    }

    public void unsetOperandImagePullSecrets() {
        this.unsetEnvVar("STRIMZI_IMAGE_PULL_SECRETS");
    }

    public void setLogLevel(String level) {
        this.setEnvVar("STRIMZI_LOG_LEVEL", level);
    }

    public void setOperandAlwaysPullPolicy() {
        this.setEnvVar("STRIMZI_IMAGE_PULL_POLICY", "Always");
    }
}

