/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb;

import io.debezium.testing.system.tools.databases.AbstractDockerDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseClient;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.MongoDBContainer;

public class DockerMongoController
extends AbstractDockerDatabaseController<MongoDBContainer, MongoDatabaseClient>
implements MongoDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerMongoController.class);
    private static final String DB_INIT_SCRIPT_PATH_CONTAINER = "/usr/local/bin/init-inventory.sh";
    public static final int MONGODB_INTERNAL_PORT = 27017;

    public DockerMongoController(MongoDBContainer container) {
        super(container);
    }

    @Override
    public int getDatabasePort() {
        return 27017;
    }

    @Override
    public String getPublicDatabaseUrl() {
        ((MongoDBContainer)this.container).getReplicaSetUrl();
        return "mongodb://" + this.getPublicDatabaseHostname() + ":" + this.getPublicDatabasePort();
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password) {
        return this.getDatabaseClient(username, password, "admin");
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password, String authSource) {
        return new MongoDatabaseClient(this.getPublicDatabaseUrl(), username, password, authSource);
    }

    @Override
    public void initialize() throws InterruptedException {
        LOGGER.info("Waiting until database is initialized");
        try {
            ((MongoDBContainer)this.container).execInContainer(new String[]{"bash", "-c", "/usr/local/bin/init-inventory.sh -h " + this.getDatabaseHostname()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

