/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures;

import fixture5.TestFixture;
import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixtureContext(provides={OpenShiftClient.class})
public class OcpClient
extends TestFixture {
    private DefaultOpenShiftClient client;
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpClient.class);

    public OcpClient(@NotNull ExtensionContext.Store store) {
        super(store);
    }

    public void setup() {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (!OpenShiftUtils.isRunningFromOcp()) {
            LOGGER.info("Running outside OCP, using OCP credentials passed from parameters");
            ((ConfigBuilder)((ConfigBuilder)configBuilder.withMasterUrl((String)ConfigProperties.OCP_URL.get())).withUsername((String)ConfigProperties.OCP_USERNAME.get())).withPassword((String)ConfigProperties.OCP_PASSWORD.get());
        }
        ((ConfigBuilder)configBuilder.withRequestRetryBackoffLimit(ConfigProperties.OCP_REQUEST_RETRY_BACKOFF_LIMIT)).withTrustCerts(true);
        this.client = new DefaultOpenShiftClient(configBuilder.build());
        this.store(OpenShiftClient.class, this.client);
    }

    public void teardown() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

