/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.resources;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.SqlDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaController;

public class ConnectorFactories {
    private final KafkaController kafka;

    public ConnectorFactories(KafkaController kafka) {
        this.kafka = kafka;
    }

    public ConnectorConfigBuilder mysql(SqlDatabaseController controller, String connectorName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder(connectorName);
        String dbHost = controller.getDatabaseHostname();
        int dbPort = controller.getDatabasePort();
        return cb.put("database.server.name", (Object)cb.getDbServerName()).put("connector.class", (Object)"io.debezium.connector.mysql.MySqlConnector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)dbPort).put("database.user", (Object)ConfigProperties.DATABASE_MYSQL_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_MYSQL_DBZ_PASSWORD).put("database.history.kafka.bootstrap.servers", (Object)this.kafka.getBootstrapAddress()).put("database.history.kafka.topic", (Object)"schema-changes.inventory");
    }

    public ConnectorConfigBuilder postgresql(SqlDatabaseController controller, String connectorName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder(connectorName);
        String dbHost = controller.getDatabaseHostname();
        int dbPort = controller.getDatabasePort();
        return cb.put("database.server.name", (Object)cb.getDbServerName()).put("connector.class", (Object)"io.debezium.connector.postgresql.PostgresConnector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)dbPort).put("database.user", (Object)ConfigProperties.DATABASE_POSTGRESQL_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_POSTGRESQL_DBZ_PASSWORD).put("database.dbname", (Object)ConfigProperties.DATABASE_POSTGRESQL_DBZ_DBNAME).put("database.dbname", (Object)ConfigProperties.DATABASE_POSTGRESQL_DBZ_DBNAME).put("slot.name", (Object)"debezium").put("plugin.name", (Object)"pgoutput");
    }

    public ConnectorConfigBuilder sqlserver(SqlDatabaseController controller, String connectorName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder(connectorName);
        String dbHost = controller.getDatabaseHostname();
        int dbPort = controller.getDatabasePort();
        return cb.put("database.server.name", (Object)cb.getDbServerName()).put("connector.class", (Object)"io.debezium.connector.sqlserver.SqlServerConnector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)dbPort).put("database.user", (Object)ConfigProperties.DATABASE_SQLSERVER_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_SQLSERVER_DBZ_PASSWORD).put("database.dbname", (Object)ConfigProperties.DATABASE_SQLSERVER_DBZ_DBNAME).put("database.history.kafka.bootstrap.servers", (Object)this.kafka.getBootstrapAddress()).put("database.history.kafka.topic", (Object)"schema-changes.inventory");
    }

    public ConnectorConfigBuilder mongo(MongoDatabaseController controller, String connectorName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder(connectorName);
        String dbHost = controller.getDatabaseHostname();
        int dbPort = controller.getDatabasePort();
        return cb.put("mongodb.name", (Object)cb.getDbServerName()).put("connector.class", (Object)"io.debezium.connector.mongodb.MongoDbConnector").put("task.max", (Object)1).put("mongodb.hosts", (Object)("rs0/" + dbHost + ":" + dbPort)).put("mongodb.user", (Object)ConfigProperties.DATABASE_MONGO_DBZ_USERNAME).put("mongodb.password", (Object)ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD);
    }

    public ConnectorConfigBuilder db2(SqlDatabaseController controller, String connectorName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder(connectorName);
        String dbHost = controller.getDatabaseHostname();
        int dbPort = controller.getDatabasePort();
        return cb.put("database.server.name", (Object)cb.getDbServerName()).put("connector.class", (Object)"io.debezium.connector.db2.Db2Connector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)dbPort).put("database.user", (Object)ConfigProperties.DATABASE_DB2_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_DB2_DBZ_PASSWORD).put("database.dbname", (Object)ConfigProperties.DATABASE_DB2_DBZ_DBNAME).put("database.cdcschema", (Object)ConfigProperties.DATABASE_DB2_CDC_SCHEMA).put("database.history.kafka.bootstrap.servers", (Object)this.kafka.getBootstrapAddress()).put("database.history.kafka.topic", (Object)"schema-changes.inventory");
    }

    public ConnectorConfigBuilder oracle(SqlDatabaseController controller, String connectorName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder(connectorName);
        String dbHost = controller.getDatabaseHostname();
        int dbPort = controller.getDatabasePort();
        return cb.put("database.server.name", (Object)cb.getDbServerName()).put("connector.class", (Object)"io.debezium.connector.oracle.OracleConnector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)dbPort).put("database.user", (Object)ConfigProperties.DATABASE_ORACLE_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_ORACLE_DBZ_PASSWORD).put("database.dbname", (Object)ConfigProperties.DATABASE_ORACLE_DBNAME).put("database.pdb.name", (Object)ConfigProperties.DATABASE_ORACLE_PDBNAME).put("schema.include.list", (Object)"DEBEZIUM").put("table.include.list", (Object)"DEBEZIUM.CUSTOMERS").put("database.pdb.name", (Object)ConfigProperties.DATABASE_ORACLE_PDBNAME).put("database.history.kafka.bootstrap.servers", (Object)this.kafka.getBootstrapAddress()).put("database.history.kafka.topic", (Object)"schema-changes.oracle").put("log.mining.strategy", (Object)"online_catalog");
    }
}

