/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.kafka;

import fixture5.TestFixture;
import fixture5.annotations.FixtureContext;
import io.debezium.testing.system.assertions.KafkaAssertions;
import io.debezium.testing.system.assertions.PlainKafkaAssertions;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.artifacts.OcpArtifactServerDeployer;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectController;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectDeployer;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.debezium.testing.system.tools.kafka.OcpKafkaDeployer;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.debezium.testing.system.tools.kafka.builders.kafka.StrimziKafkaBuilder;
import io.debezium.testing.system.tools.kafka.builders.kafka.StrimziKafkaConnectBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;

@FixtureContext(requires={OpenShiftClient.class}, provides={KafkaController.class, KafkaConnectController.class, KafkaAssertions.class})
public class OcpKafka
extends TestFixture {
    private final OpenShiftClient ocp = (OpenShiftClient)this.retrieve(OpenShiftClient.class);
    private final String project = ConfigProperties.OCP_PROJECT_DBZ;
    String KAFKA_CONNECT_LOGGING = "/kafka-resources/020-kafka-connect-cfg.yaml";
    String ARTIFACT_SERVER_DEPLOYMENT = "/artifact-server/010-deployment.yaml";
    String ARTIFACT_SERVER_SERVICE = "/artifact-server/020-service.yaml";

    public OcpKafka(@NotNull ExtensionContext.Store store) {
        super(store);
    }

    public void setup() {
        try {
            StrimziOperatorController operatorController = this.updateKafkaOperator();
            this.deployKafkaCluster(operatorController);
            this.deployConnectCluster(operatorController);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while setting up Kafka", e);
        }
    }

    public void teardown() {
    }

    private void deployKafkaCluster(StrimziOperatorController operatorController) throws Exception {
        OcpKafkaDeployer kafkaDeployer = new OcpKafkaDeployer.Builder(StrimziKafkaBuilder.base()).withOcpClient(this.ocp).withHttpClient(new OkHttpClient()).withProject(this.project).withOperatorController(operatorController).build();
        OcpKafkaController controller = kafkaDeployer.deploy();
        this.store(KafkaController.class, controller);
        this.store(KafkaAssertions.class, new PlainKafkaAssertions(controller.getDefaultConsumerProperties()));
    }

    private void deployConnectCluster(StrimziOperatorController operatorController) throws InterruptedException {
        if (ConfigProperties.STRIMZI_KC_BUILD) {
            this.deployArtifactServer();
        }
        StrimziKafkaConnectBuilder strimziBuilder = StrimziKafkaConnectBuilder.base();
        OcpKafkaConnectDeployer connectDeployer = new OcpKafkaConnectDeployer.Builder(strimziBuilder).withOcpClient(this.ocp).withHttpClient(new OkHttpClient()).withProject(this.project).withLoggingAndMetricsFromCfgMap(this.KAFKA_CONNECT_LOGGING).withConnectorResources(ConfigProperties.STRIMZI_OPERATOR_CONNECTORS).withKcBuild(ConfigProperties.STRIMZI_KC_BUILD).withOperatorController(operatorController).build();
        OcpKafkaConnectController controller = connectDeployer.deploy();
        controller.allowServiceAccess();
        controller.exposeApi();
        controller.exposeMetrics();
        this.store(KafkaConnectController.class, controller);
    }

    private void deployArtifactServer() throws InterruptedException {
        OcpArtifactServerDeployer deployer = new OcpArtifactServerDeployer.Builder().withOcpClient(this.ocp).withHttpClient(new OkHttpClient()).withProject(this.project).withDeployment(this.ARTIFACT_SERVER_DEPLOYMENT).withService(this.ARTIFACT_SERVER_SERVICE).build();
        deployer.deploy();
    }

    private StrimziOperatorController updateKafkaOperator() {
        StrimziOperatorController operatorController = StrimziOperatorController.forProject((String)this.project, (OpenShiftClient)this.ocp);
        operatorController.setLogLevel("DEBUG");
        operatorController.setAlwaysPullPolicy();
        operatorController.setOperandAlwaysPullPolicy();
        operatorController.setSingleReplica();
        ConfigProperties.OCP_PULL_SECRET_PATH.ifPresent(arg_0 -> ((StrimziOperatorController)operatorController).deployPullSecret(arg_0));
        operatorController.updateOperator();
        return operatorController;
    }
}

