/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.registry;

import io.debezium.testing.system.fixtures.OcpClient;
import io.debezium.testing.system.fixtures.TestSetupFixture;
import io.debezium.testing.system.fixtures.kafka.KafkaRuntimeFixture;
import io.debezium.testing.system.fixtures.registry.RegistryRuntimeFixture;
import io.debezium.testing.system.fixtures.registry.RegistrySetupFixture;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.registry.ApicurioOperatorController;
import io.debezium.testing.system.tools.registry.OcpApicurioController;
import io.debezium.testing.system.tools.registry.OcpApicurioDeployer;
import io.debezium.testing.system.tools.registry.RegistryController;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;

public interface OcpApicurio
extends TestSetupFixture,
RegistrySetupFixture,
RegistryRuntimeFixture,
KafkaRuntimeFixture,
OcpClient {
    public static final String REGISTRY_DEPLOYMENT_PATH = "/registry-resources/v1/010-registry-kafkasql.yaml";

    @Override
    default public void setupRegistry() throws Exception {
        this.updateApicurioOperator(ConfigProperties.OCP_PROJECT_REGISTRY, this.getOcpClient());
        OcpApicurioDeployer deployer = ((OcpApicurioDeployer.Builder)((OcpApicurioDeployer.Builder)((OcpApicurioDeployer.Builder)((OcpApicurioDeployer.Builder)new OcpApicurioDeployer.Builder().withOcpClient(this.getOcpClient())).withHttpClient(new OkHttpClient())).withProject(ConfigProperties.OCP_PROJECT_REGISTRY)).withYamlPath(REGISTRY_DEPLOYMENT_PATH)).build();
        OcpApicurioController controller = (OcpApicurioController)deployer.deploy();
        this.setRegistryController((RegistryController)controller);
    }

    default public void updateApicurioOperator(String project, OpenShiftClient ocp) {
        ApicurioOperatorController operatorController = ApicurioOperatorController.forProject((String)project, (OpenShiftClient)ocp);
        ConfigProperties.OCP_PULL_SECRET_PATH.ifPresent(arg_0 -> ((ApicurioOperatorController)operatorController).deployPullSecret(arg_0));
        operatorController.updateOperator();
    }

    @Override
    default public void teardownRegistry() {
    }
}

