/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.assertions;

import io.debezium.testing.system.tools.WaitConditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ThrowingRunnable;

public interface KafkaAssertions<K, V> {
    public static void awaitAssert(long timeout, TimeUnit unit, ThrowingRunnable assertion) {
        Awaitility.await().pollDelay(2L, TimeUnit.SECONDS).atMost(timeout, unit).untilAsserted(assertion);
    }

    public static void awaitAssert(ThrowingRunnable assertion) {
        KafkaAssertions.awaitAssert(WaitConditions.scaled((long)1L), TimeUnit.MINUTES, assertion);
    }

    default public void assertTopicsExist(String ... names) {
        try (Consumer consumer = this.getConsumer();){
            Awaitility.await().atMost(WaitConditions.scaled((long)2L), TimeUnit.MINUTES).untilAsserted(() -> {
                Set topics = consumer.listTopics().keySet();
                Assertions.assertThat(topics).contains((Object[])names);
            });
        }
    }

    default public void assertRecordsCount(String topic, int count) {
        try (Consumer<K, V> consumer = this.getConsumer();){
            consumer.subscribe(Collections.singleton(topic));
            ConsumerRecords records = consumer.poll(Duration.of(10L, ChronoUnit.SECONDS));
            consumer.seekToBeginning((Collection)consumer.assignment());
            ((AbstractIntegerAssert)Assertions.assertThat((int)records.count()).withFailMessage("Expecting topic '%s' to have <%d> messages but it had <%d>.", new Object[]{topic, count, records.count()})).isEqualTo(count);
        }
    }

    default public void assertMinimalRecordsCount(String topic, int count) {
        try (Consumer<K, V> consumer = this.getConsumer();){
            consumer.subscribe(Collections.singleton(topic));
            ConsumerRecords records = consumer.poll(Duration.of(10L, ChronoUnit.SECONDS));
            consumer.seekToBeginning((Collection)consumer.assignment());
            ((AbstractIntegerAssert)Assertions.assertThat((int)records.count()).withFailMessage("Expecting topic '%s' to have  at least <%d> messages but it had <%d>.", new Object[]{topic, count, records.count()})).isGreaterThanOrEqualTo(count);
        }
    }

    public void assertRecordsContain(String var1, String var2);

    public Consumer<K, V> getConsumer();
}

