/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.databases;

import io.debezium.testing.system.fixtures.OcpClient;
import io.debezium.testing.system.fixtures.TestSetupFixture;
import io.debezium.testing.system.fixtures.databases.SqlDatabaseFixture;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.SqlDatabaseController;
import io.debezium.testing.system.tools.databases.oracle.OcpOracleDeployer;

public interface OcpOracle
extends TestSetupFixture,
SqlDatabaseFixture,
OcpClient {
    public static final String DB_DEPLOYMENT_PATH = "/database-resources/oracle/deployment.yaml";
    public static final String DB_SERVICE_PATH_LB = "/database-resources/oracle/service-lb.yaml";
    public static final String DB_SERVICE_PATH = "/database-resources/oracle/service.yaml";

    @Override
    default public void setupDatabase() throws Exception {
        Class.forName("oracle.jdbc.OracleDriver");
        OcpOracleDeployer deployer = ((OcpOracleDeployer.Builder)((OcpOracleDeployer.Builder)((OcpOracleDeployer.Builder)((OcpOracleDeployer.Builder)((OcpOracleDeployer.Builder)new OcpOracleDeployer.Builder().withOcpClient(this.getOcpClient())).withProject(ConfigProperties.OCP_PROJECT_ORACLE)).withDeployment(DB_DEPLOYMENT_PATH)).withServices(new String[]{DB_SERVICE_PATH, DB_SERVICE_PATH_LB})).withPullSecrets((String)ConfigProperties.OCP_PULL_SECRET_PATH.get())).build();
        SqlDatabaseController controller = (SqlDatabaseController)deployer.deploy();
        controller.initialize();
        this.setDbController(controller);
    }

    @Override
    default public void teardownDatabase() throws Exception {
        ((SqlDatabaseController)this.getDbController()).reload();
    }
}

