/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.kafka;

import io.debezium.testing.system.fixtures.OcpClient;
import io.debezium.testing.system.fixtures.kafka.KafkaRuntimeFixture;
import io.debezium.testing.system.fixtures.kafka.KafkaSetupFixture;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.artifacts.OcpArtifactServerController;
import io.debezium.testing.system.tools.artifacts.OcpArtifactServerDeployer;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectController;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectDeployer;
import io.debezium.testing.system.tools.kafka.OcpKafkaDeployer;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Arrays;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;

public interface OcpKafka
extends KafkaSetupFixture,
KafkaRuntimeFixture,
OcpClient {
    public static final String KAFKA = "/kafka-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/010-kafka.yaml";
    public static final String KAFKA_CONNECT_LOGGING = "/kafka-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/020-kafka-connect-cfg.yaml";
    public static final String KAFKA_CONNECT = "/kafka-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/021-kafka-connect.yaml";
    public static final String KAFKA_CONNECT_BUILD = "/kafka-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/121-kafka-connect-build.yaml";
    public static final String ARTIFACT_SERVER_DEPLOYMENT = "/artifact-server/010-deployment.yaml";
    public static final String ARTIFACT_SERVER_SERVICE = "/artifact-server/020-service.yaml";

    @Override
    default public void setupKafka() throws Exception {
        OpenShiftClient ocp = this.getOcpClient();
        KafkaController controller = this.deployKafkaCluster(ocp);
        KafkaConnectController connectController = this.deployKafkaConnectCluster(ocp);
        this.setKafkaController(controller);
        this.setKafkaConnectController(connectController);
    }

    @Override
    default public void teardownKafka() throws Exception {
    }

    default public KafkaController deployKafkaCluster(OpenShiftClient ocp) throws Exception {
        this.updateKafkaOperator(ConfigProperties.OCP_PROJECT_DBZ, ocp);
        OcpKafkaDeployer kafkaDeployer = new OcpKafkaDeployer.Builder().withOcpClient(ocp).withHttpClient(new OkHttpClient()).withProject(ConfigProperties.OCP_PROJECT_DBZ).withYamlPath(KAFKA).build();
        return kafkaDeployer.deploy();
    }

    default public KafkaConnectController deployKafkaConnectCluster(OpenShiftClient ocp) throws InterruptedException {
        String yamlDescriptor = KAFKA_CONNECT;
        if (ConfigProperties.STRIMZI_KC_BUILD) {
            yamlDescriptor = KAFKA_CONNECT_BUILD;
            this.deployArtifactServer(ocp);
        }
        OcpKafkaConnectDeployer connectDeployer = new OcpKafkaConnectDeployer.Builder().withOcpClient(ocp).withHttpClient(new OkHttpClient()).withProject(ConfigProperties.OCP_PROJECT_DBZ).withYamlPath(yamlDescriptor).withCfgYamlPath(KAFKA_CONNECT_LOGGING).withConnectorResources(ConfigProperties.STRIMZI_OPERATOR_CONNECTORS).build();
        OcpKafkaConnectController controller = connectDeployer.deploy();
        controller.allowServiceAccess();
        controller.exposeApi();
        controller.exposeMetrics();
        return controller;
    }

    default public void deployArtifactServer(OpenShiftClient ocp) throws InterruptedException {
        OcpArtifactServerDeployer deployer = new OcpArtifactServerDeployer.Builder().withOcpClient(ocp).withHttpClient(new OkHttpClient()).withProject(ConfigProperties.OCP_PROJECT_DBZ).withDeployment(ARTIFACT_SERVER_DEPLOYMENT).withService(ARTIFACT_SERVER_SERVICE).build();
        OcpArtifactServerController controller = deployer.deploy();
    }

    default public void updateKafkaOperator(String project, OpenShiftClient ocp) {
        StrimziOperatorController operatorController = StrimziOperatorController.forProject((String)project, (OpenShiftClient)ocp);
        operatorController.setLogLevel("DEBUG");
        operatorController.setAlwaysPullPolicy();
        operatorController.setOperandAlwaysPullPolicy();
        operatorController.setSingleReplica();
        ConfigProperties.OCP_PULL_SECRET_PATHS.ifPresent(paths -> {
            String secrets = Arrays.stream(paths.split(",")).map(arg_0 -> ((StrimziOperatorController)operatorController).deployPullSecret(arg_0)).map(Secret::getMetadata).map(ObjectMeta::getName).peek(arg_0 -> ((StrimziOperatorController)operatorController).setImagePullSecret(arg_0)).collect(Collectors.joining(","));
            if (ConfigProperties.STRIMZI_KC_BUILD) {
                operatorController.unsetOperandImagePullSecrets();
            } else {
                operatorController.setOperandImagePullSecrets(secrets);
            }
        });
        operatorController.updateOperator();
    }
}

