/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.registry;

import io.debezium.testing.system.fixtures.OcpClient;
import io.debezium.testing.system.fixtures.TestSetupFixture;
import io.debezium.testing.system.fixtures.kafka.KafkaRuntimeFixture;
import io.debezium.testing.system.fixtures.registry.RegistryRuntimeFixture;
import io.debezium.testing.system.fixtures.registry.RegistrySetupFixture;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.registry.ApicurioOperatorController;
import io.debezium.testing.system.tools.registry.OcpApicurioV1Controller;
import io.debezium.testing.system.tools.registry.OcpApicurioV1Deployer;
import io.debezium.testing.system.tools.registry.OcpApicurioV2Controller;
import io.debezium.testing.system.tools.registry.OcpApicurioV2Deployer;
import io.debezium.testing.system.tools.registry.RegistryController;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Arrays;
import okhttp3.OkHttpClient;

public interface OcpApicurio
extends TestSetupFixture,
RegistrySetupFixture,
RegistryRuntimeFixture,
KafkaRuntimeFixture,
OcpClient {
    public static final String REGISTRY_V1_DEPLOYMENT_PATH = "/registry-resources/v1alpha1/030-registry-streams.yaml";
    public static final String REGISTRY_V2_DEPLOYMENT_PATH = "/registry-resources/v1/010-registry-kafkasql.yaml";
    public static final String REGISTRY_STORAGE_TOPIC_PATH = "/registry-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/010-storage-topic.yaml";
    public static final String REGISTRY_ID_TOPIC_PATH = "/registry-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/020-global-id-topic.yaml";

    @Override
    default public void setupRegistry() throws Exception {
        this.updateApicurioOperator(ConfigProperties.OCP_PROJECT_REGISTRY, this.getOcpClient());
        switch (ConfigProperties.APICURIO_CRD_VERSION) {
            case "v1": {
                this.setupApicurioV2();
                break;
            }
            case "v1alpha1": {
                this.setupApicurioV1();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported Apicurio CR version " + ConfigProperties.APICURIO_CRD_VERSION);
            }
        }
    }

    default public void updateApicurioOperator(String project, OpenShiftClient ocp) {
        ApicurioOperatorController operatorController = ApicurioOperatorController.forProject((String)project, (OpenShiftClient)ocp);
        ConfigProperties.OCP_PULL_SECRET_PATHS.ifPresent(paths -> Arrays.stream(paths.split(",")).map(arg_0 -> ((ApicurioOperatorController)operatorController).deployPullSecret(arg_0)).map(Secret::getMetadata).map(ObjectMeta::getName).forEach(arg_0 -> ((ApicurioOperatorController)operatorController).setImagePullSecret(arg_0)));
        operatorController.updateOperator();
    }

    @Override
    default public void teardownRegistry() {
    }

    default public void setupApicurioV1() throws InterruptedException {
        OcpApicurioV1Deployer deployer = ((OcpApicurioV1Deployer.Builder)((OcpApicurioV1Deployer.Builder)((OcpApicurioV1Deployer.Builder)((OcpApicurioV1Deployer.Builder)new OcpApicurioV1Deployer.Builder().withOcpClient(this.getOcpClient())).withHttpClient(new OkHttpClient())).withProject(ConfigProperties.OCP_PROJECT_REGISTRY)).withYamlPath(REGISTRY_V1_DEPLOYMENT_PATH)).withTopicsYamlPath(REGISTRY_STORAGE_TOPIC_PATH, REGISTRY_ID_TOPIC_PATH).withKafkaController(this.getKafkaController()).build();
        OcpApicurioV1Controller controller = deployer.deploy();
        this.setRegistryController((RegistryController)controller);
    }

    default public void setupApicurioV2() throws InterruptedException {
        OcpApicurioV2Deployer deployer = ((OcpApicurioV2Deployer.Builder)((OcpApicurioV2Deployer.Builder)((OcpApicurioV2Deployer.Builder)((OcpApicurioV2Deployer.Builder)new OcpApicurioV2Deployer.Builder().withOcpClient(this.getOcpClient())).withHttpClient(new OkHttpClient())).withProject(ConfigProperties.OCP_PROJECT_REGISTRY)).withYamlPath(REGISTRY_V2_DEPLOYMENT_PATH)).build();
        OcpApicurioV2Controller controller = (OcpApicurioV2Controller)deployer.deploy();
        this.setRegistryController((RegistryController)controller);
    }
}

