/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.OperatorController;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.debezium.testing.system.tools.registry.OcpRegistryController;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpRegistryDeployer
extends AbstractOcpDeployer<OcpRegistryController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpRegistryDeployer.class);
    private final KafkaController kafkaController;
    private final String yamlPath;
    private final String idTopicYamlPath;
    private final String storageTopicYamlPath;

    private OcpRegistryDeployer(String project, String yamlPath, String storageTopicYamlPath, String idTopicYamlPath, KafkaController kafkaController, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.kafkaController = kafkaController;
        this.yamlPath = yamlPath;
        this.storageTopicYamlPath = storageTopicYamlPath;
        this.idTopicYamlPath = idTopicYamlPath;
    }

    public OperatorController getOperator() {
        Deployment operator = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName("apicurio-registry-operator")).get();
        return new OperatorController(operator, Collections.singletonMap("name", "apicurio-registry-operator"), this.ocp);
    }

    public NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, Resource<ApicurioRegistry>> registryOperation() {
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.ocp.apiextensions().v1().customResourceDefinitions().load(OcpRegistryDeployer.class.getResourceAsStream("/crds/apicur.io_apicurioregistries_crd.yaml"))).get();
        CustomResourceDefinitionContext context = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        return (NonNamespaceOperation)this.ocp.customResources(context, ApicurioRegistry.class, ApicurioRegistryList.class).inNamespace(this.project);
    }

    public ApicurioRegistry waitForRegistry(String name) throws InterruptedException {
        LOGGER.info("Waiting for deployments of registry '" + name + "'");
        Awaitility.await().atMost(WaitConditions.scaled(1L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> !this.getRegistryDeployments(name).isEmpty());
        DeploymentConfig dc = this.getRegistryDeployments(name).get(0);
        ((DeployableScalableResource)((NonNamespaceOperation)this.ocp.deploymentConfigs().inNamespace(this.project)).withName(dc.getMetadata().getName())).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
        return (ApicurioRegistry)((Resource)this.registryOperation().withName(name)).get();
    }

    private List<DeploymentConfig> getRegistryDeployments(String name) {
        return ((DeploymentConfigList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.deploymentConfigs().inNamespace(this.project)).withLabel("app", name)).list()).getItems();
    }

    @Override
    public OcpRegistryController deploy() throws InterruptedException {
        LOGGER.info("Deploying Apicurio Registry from " + this.yamlPath);
        ((OcpKafkaController)this.kafkaController).deployTopic(this.storageTopicYamlPath);
        ((OcpKafkaController)this.kafkaController).deployTopic(this.idTopicYamlPath);
        ApicurioRegistry registry = YAML.fromResource(this.yamlPath, ApicurioRegistry.class);
        registry = (ApicurioRegistry)this.registryOperation().createOrReplace((Object[])new ApicurioRegistry[]{registry});
        registry = this.waitForRegistry(registry.getMetadata().getName());
        return new OcpRegistryController(registry, this.ocp, this.http);
    }

    public static class Builder
    implements Deployer.Builder<Builder, OcpRegistryDeployer> {
        private String project;
        private OpenShiftClient ocpClient;
        private OkHttpClient httpClient;
        private String yamlPath;
        private String storageTopicYamlPath;
        private String idTopicYamlPath;
        private KafkaController kafkaController;

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public Builder withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return this;
        }

        public Builder withHttpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withYamlPath(String yamlPath) {
            this.yamlPath = yamlPath;
            return this;
        }

        public Builder withTopicsYamlPath(String storageTopicYamlPath, String idTopicYamlPath) {
            this.storageTopicYamlPath = storageTopicYamlPath;
            this.idTopicYamlPath = idTopicYamlPath;
            return this;
        }

        public Builder withKafkaController(KafkaController kafkaController) {
            this.kafkaController = kafkaController;
            return this;
        }

        @Override
        public OcpRegistryDeployer build() {
            return new OcpRegistryDeployer(this.project, this.yamlPath, this.storageTopicYamlPath, this.idTopicYamlPath, this.kafkaController, this.ocpClient, this.httpClient);
        }
    }
}

