/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tests;

import io.debezium.testing.system.fixtures.TestRuntimeFixture;
import io.debezium.testing.system.fixtures.TestSetupFixture;
import io.debezium.testing.system.tools.databases.DatabaseController;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.registry.OcpRegistryController;
import java.util.Optional;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class ConnectorTest<D extends DatabaseController<?>>
implements TestSetupFixture,
TestRuntimeFixture<D> {
    static Logger LOGGER = LoggerFactory.getLogger(ConnectorTest.class);
    private KafkaController kafkaController;
    private KafkaConnectController kafkaConnectController;
    private D dbController;
    private ConnectorConfigBuilder connectorConfig;
    private OcpRegistryController registryController;

    @BeforeAll
    public void setupFixtures() throws Exception {
        LOGGER.info("Initializing test fixtures from {}", (Object)this.getClass().getName());
        this.setupKafka();
        this.setupRegistry();
        this.setupDatabase();
        this.setupConnector();
    }

    @AfterAll
    public void teardownFixtures() throws Exception {
        this.teardownConnector();
        this.teardownDatabase();
        this.teardownRegistry();
        this.teardownKafka();
    }

    @Override
    public KafkaConnectController getKafkaConnectController() {
        return this.kafkaConnectController;
    }

    @Override
    public void setKafkaConnectController(KafkaConnectController controller) {
        this.kafkaConnectController = controller;
    }

    @Override
    public KafkaController getKafkaController() {
        return this.kafkaController;
    }

    @Override
    public void setKafkaController(KafkaController controller) {
        this.kafkaController = controller;
    }

    @Override
    public D getDbController() {
        return this.dbController;
    }

    @Override
    public void setDbController(D controller) {
        this.dbController = controller;
    }

    @Override
    public ConnectorConfigBuilder getConnectorConfig() {
        return this.connectorConfig;
    }

    @Override
    public void setConnectorConfig(ConnectorConfigBuilder config) {
        this.connectorConfig = config;
    }

    @Override
    public Optional<OcpRegistryController> getRegistryController() {
        return Optional.ofNullable(this.registryController);
    }

    @Override
    public void setRegistryController(OcpRegistryController controller) {
        this.registryController = controller;
    }
}

