/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.fixtures.registry;

import io.debezium.testing.system.fixtures.OcpClient;
import io.debezium.testing.system.fixtures.TestSetupFixture;
import io.debezium.testing.system.fixtures.connectors.ConnectorDecoratorFixture;
import io.debezium.testing.system.fixtures.kafka.KafkaRuntimeFixture;
import io.debezium.testing.system.fixtures.registry.RegistryRuntimeFixture;
import io.debezium.testing.system.fixtures.registry.RegistrySetupFixture;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.registry.OcpRegistryController;
import io.debezium.testing.system.tools.registry.OcpRegistryDeployer;
import okhttp3.OkHttpClient;

public interface OcpApicurio
extends TestSetupFixture,
RegistrySetupFixture,
RegistryRuntimeFixture,
KafkaRuntimeFixture,
OcpClient,
ConnectorDecoratorFixture {
    public static final String REGISTRY_DEPLOYMENT_PATH = "/registry-resources/030-registry-streams.yaml";
    public static final String REGISTRY_STORAGE_TOPIC_PATH = "/registry-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/010-storage-topic.yaml";
    public static final String REGISTRY_ID_TOPIC_PATH = "/registry-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/020-global-id-topic.yaml";

    @Override
    default public void setupRegistry() throws Exception {
        OcpRegistryDeployer deployer = new OcpRegistryDeployer.Builder().withOcpClient(this.getOcpClient()).withHttpClient(new OkHttpClient()).withProject(ConfigProperties.OCP_PROJECT_REGISTRY).withYamlPath(REGISTRY_DEPLOYMENT_PATH).withTopicsYamlPath(REGISTRY_STORAGE_TOPIC_PATH, REGISTRY_ID_TOPIC_PATH).withKafkaController(this.getKafkaController()).build();
        OcpRegistryController controller = deployer.deploy();
        this.setRegistryController(controller);
    }

    @Override
    default public void teardownRegistry() throws Exception {
    }

    @Override
    default public void decorateConnectorConfig(ConnectorConfigBuilder config) {
        config.addApicurioAvroSupport(this.getRegistryController().orElseThrow(() -> new IllegalStateException("No registry controller")).getRegistryApiAddress());
    }
}

