/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases;

import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.debezium.testing.openshift.tools.WaitConditions;
import io.debezium.testing.openshift.tools.databases.DatabaseClient;
import io.debezium.testing.openshift.tools.databases.DatabaseController;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOcpDatabaseController<C extends DatabaseClient<?, ?>>
implements DatabaseController<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOcpDatabaseController.class);
    protected final OpenShiftClient ocp;
    protected final String project;
    protected final OpenShiftUtils ocpUtils;
    protected Deployment deployment;
    protected String name;
    protected List<Service> services;

    public AbstractOcpDatabaseController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        this.deployment = deployment;
        this.name = deployment.getMetadata().getName();
        this.project = deployment.getMetadata().getNamespace();
        this.services = services;
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    private Service getService() {
        return (Service)((ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName(this.deployment.getMetadata().getName() + "-lb")).get();
    }

    private void awaitIngress() {
        LOGGER.info("Waiting for LoadBalancerIngress to be available");
        Awaitility.await().atMost(WaitConditions.scaled(2L), TimeUnit.MINUTES).pollInterval(3L, TimeUnit.SECONDS).until(() -> this.getService().getStatus().getLoadBalancer().getIngress().size() > 0);
    }

    @Override
    public void reload() throws InterruptedException {
        LOGGER.info("Recreating all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        ((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabel("deployment", this.name)).delete();
        this.deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
        LOGGER.info("Deployment '" + this.name + "' is available");
    }

    @Override
    public String getDatabaseHostname() {
        this.awaitIngress();
        return ((LoadBalancerIngress)this.getService().getStatus().getLoadBalancer().getIngress().get(0)).getHostname();
    }

    @Override
    public int getDatabasePort() {
        this.awaitIngress();
        return this.getService().getSpec().getPorts().stream().filter(p -> p.getName().equals("db")).findAny().get().getPort();
    }
}

