/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases;

import io.debezium.testing.openshift.tools.WaitConditions;
import io.debezium.testing.openshift.tools.databases.AbstractOcpDatabaseController;
import io.debezium.testing.openshift.tools.databases.Commands;
import io.debezium.testing.openshift.tools.databases.DatabaseClient;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDatabaseClient
implements DatabaseClient<Connection, SQLException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOcpDatabaseController.class);
    private final String url;
    private final String username;
    private final String password;

    public SqlDatabaseClient(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    private boolean doExecute(Commands<Connection, SQLException> commands) throws SQLException {
        try (Connection con = DriverManager.getConnection(this.url, this.username, this.password);){
            commands.execute(con);
        }
        return true;
    }

    @Override
    public void execute(Commands<Connection, SQLException> commands) throws SQLException {
        Awaitility.await().atMost(WaitConditions.scaled(2L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).ignoreExceptions().until(() -> this.doExecute(commands));
    }

    public void execute(String database, Commands<Connection, SQLException> commands) throws SQLException {
        Commands withDatabase = con -> con.setCatalog(database);
        this.execute((Connection con) -> withDatabase.andThen(commands).execute((Connection)con));
    }

    public void execute(String database, String command) throws SQLException {
        LOGGER.info("Running SQL Command [" + database + "]: " + command);
        this.execute(database, (Connection con) -> {
            try (Statement stmt = con.createStatement();){
                stmt.execute(command);
            }
        });
    }

    public void execute(String command) throws SQLException {
        LOGGER.info("Running SQL Command: " + command);
        this.execute((Connection con) -> {
            try (Statement stmt = con.createStatement();){
                stmt.execute(command);
            }
        });
    }
}

