/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.kafka;

import io.debezium.testing.openshift.tools.OperatorController;
import io.debezium.testing.openshift.tools.YAML;
import io.debezium.testing.openshift.tools.kafka.OcpKafkaController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrimziOperatorController
extends OperatorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaController.class);
    private final OpenShiftClient ocp;
    private final String project;
    private final String name;
    private Deployment operator;

    public static StrimziOperatorController forProject(String project, OpenShiftClient ocp) {
        Deployment operator = (Deployment)((RollableScalableResource)((NonNamespaceOperation)ocp.apps().deployments().inNamespace(project)).withName("strimzi-cluster-operator")).get();
        return new StrimziOperatorController(operator, ocp);
    }

    private StrimziOperatorController(Deployment operator, OpenShiftClient ocp) {
        super(operator, Collections.singletonMap("strimzi.io/kind", "cluster-operator"), ocp);
        this.operator = operator;
        this.name = operator.getMetadata().getName();
        this.project = operator.getMetadata().getNamespace();
        this.ocp = ocp;
    }

    public void setOperandImagePullSecrets(String names) {
        this.setEnvVar("STRIMZI_IMAGE_PULL_SECRETS", names);
    }

    public void setLogLevel(String level) {
        this.setEnvVar("STRIMZI_LOG_LEVEL", level);
    }

    @Override
    public void setAlwaysPullPolicy() {
        LOGGER.info("Using 'Always' pull policy for all containers of deployment " + this.name + "'");
        List containers = this.operator.getSpec().getTemplate().getSpec().getContainers();
        containers.forEach(c -> c.setImagePullPolicy("Always"));
    }

    public void setOperandAlwaysPullPolicy() {
        this.setEnvVar("STRIMZI_IMAGE_PULL_POLICY", "Always");
    }

    public Secret deployPullSecret(String yamlPath) {
        LOGGER.info("Deploying Secret from " + yamlPath);
        return (Secret)((NonNamespaceOperation)this.ocp.secrets().inNamespace(this.project)).createOrReplace((Object[])new Secret[]{YAML.from(yamlPath, Secret.class)});
    }
}

