/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.sqlserver;

import io.debezium.testing.openshift.ConnectorTestBase;
import io.debezium.testing.openshift.assertions.KafkaAssertions;
import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.databases.SqlDatabaseClient;
import io.debezium.testing.openshift.tools.databases.SqlDatabaseController;
import io.debezium.testing.openshift.tools.databases.sqlserver.OcpSqlServerDeployer;
import io.debezium.testing.openshift.tools.kafka.ConnectorConfigBuilder;
import java.io.IOException;
import java.sql.SQLException;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Tags(value={@Tag(value="acceptance"), @Tag(value="sqlserver")})
public class SqlServerConnectorIT
extends ConnectorTestBase {
    public static final String DB_DEPLOYMENT_PATH = "/database-resources/sqlserver/deployment.yaml";
    public static final String DB_SERVICE_PATH_LB = "/database-resources/sqlserver/service-lb.yaml";
    public static final String DB_SERVICE_PATH = "/database-resources/sqlserver/service.yaml";
    public static final String CONNECTOR_NAME = "inventory-connector-sqlserver";
    private static SqlDatabaseController dbController;
    private static ConnectorConfigBuilder connectorConfig;
    private static String connectorName;
    private static String dbServerName;

    @BeforeAll
    public static void setupDatabase() throws IOException, InterruptedException, ClassNotFoundException {
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        if (!ConfigProperties.DATABASE_MYSQL_HOST.isPresent()) {
            OcpSqlServerDeployer deployer = ((OcpSqlServerDeployer.Deployer)((OcpSqlServerDeployer.Deployer)((OcpSqlServerDeployer.Deployer)((OcpSqlServerDeployer.Deployer)new OcpSqlServerDeployer.Deployer().withOcpClient(ocp)).withProject(ConfigProperties.OCP_PROJECT_SQLSERVER)).withDeployment(DB_DEPLOYMENT_PATH)).withServices(new String[]{DB_SERVICE_PATH, DB_SERVICE_PATH_LB})).build();
            dbController = (SqlDatabaseController)deployer.deploy();
            dbController.initialize();
        }
        connectorName = "inventory-connector-sqlserver-" + testUtils.getUniqueId();
        dbServerName = connectorName.replaceAll("-", "_");
        connectorConfig = connectorFactories.sqlserver(dbServerName);
        if (ConfigProperties.DEPLOY_SERVICE_REGISTRY) {
            connectorConfig.addApicurioAvroSupport(registryController.getRegistryApiAddress());
        }
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
    }

    @AfterAll
    public static void tearDownDatabase() throws IOException, InterruptedException {
        kafkaConnectController.undeployConnector(connectorName);
        dbController.reload();
    }

    private void insertCustomer(String firstName, String lastName, String email) throws SQLException {
        SqlDatabaseClient client = dbController.getDatabaseClient(ConfigProperties.DATABASE_SQLSERVER_DBZ_USERNAME, ConfigProperties.DATABASE_SQLSERVER_DBZ_PASSWORD);
        String sql = "INSERT INTO customers (first_name, last_name, email) VALUES ('" + firstName + "', '" + lastName + "', '" + email + "')";
        client.execute(ConfigProperties.DATABASE_SQLSERVER_DBZ_DBNAME, sql);
    }

    @Test
    @Order(value=1)
    public void shouldHaveRegisteredConnector() {
        Request r = new Request.Builder().url(kafkaConnectController.getApiURL().resolve("/connectors")).build();
        KafkaAssertions.awaitAssert(() -> {
            try (Response res = httpClient.newCall(r).execute();){
                Assertions.assertThat((String)res.body().string()).contains(new CharSequence[]{connectorName});
            }
        });
    }

    @Test
    @Order(value=2)
    public void shouldCreateKafkaTopics() {
        assertions.assertTopicsExist(dbServerName + ".dbo.customers", dbServerName + ".dbo.orders", dbServerName + ".dbo.products", dbServerName + ".dbo.products_on_hand");
    }

    @Test
    @Order(value=3)
    public void shouldContainRecordsInCustomersTopic() throws IOException {
        kafkaConnectController.waitForSqlServerSnapshot(dbServerName);
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".dbo.customers", 4));
    }

    @Test
    @Order(value=4)
    public void shouldStreamChanges() throws SQLException {
        this.insertCustomer("Tom", "Tester", "tom@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".dbo.customers", 5));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(dbServerName + ".dbo.customers", "tom@test.com"));
    }

    @Test
    @Order(value=5)
    public void shouldBeDown() throws SQLException, IOException {
        kafkaConnectController.undeployConnector(connectorName);
        this.insertCustomer("Jerry", "Tester", "jerry@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".dbo.customers", 5));
    }

    @Test
    @Order(value=6)
    public void shouldResumeStreamingAfterRedeployment() throws IOException, InterruptedException {
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".dbo.customers", 6));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(dbServerName + ".dbo.customers", "jerry@test.com"));
    }

    @Test
    @Order(value=7)
    public void shouldBeDownAfterCrash() throws SQLException {
        operatorController.disable();
        kafkaConnectController.destroy();
        this.insertCustomer("Nibbles", "Tester", "nibbles@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".dbo.customers", 6));
    }

    @Test
    @Order(value=8)
    public void shouldResumeStreamingAfterCrash() throws InterruptedException {
        operatorController.enable();
        kafkaConnectController.waitForCluster();
        KafkaAssertions.awaitAssert(() -> assertions.assertMinimalRecordsCount(dbServerName + ".dbo.customers", 7));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(dbServerName + ".dbo.customers", "nibbles@test.com"));
    }
}

