/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.resources;

import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.kafka.ConnectorConfigBuilder;

public class ConnectorFactories {
    public ConnectorConfigBuilder mysql(String dbServerName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder();
        String dbHost = ConfigProperties.DATABASE_MYSQL_HOST.orElse("mysql." + ConfigProperties.OCP_PROJECT_MYSQL + ".svc.cluster.local");
        return cb.put("database.server.name", (Object)dbServerName).put("connector.class", (Object)"io.debezium.connector.mysql.MySqlConnector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)ConfigProperties.DATABASE_MYSQL_PORT).put("database.user", (Object)ConfigProperties.DATABASE_MYSQL_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_MYSQL_DBZ_PASSWORD).put("database.history.kafka.bootstrap.servers", (Object)("debezium-kafka-cluster-kafka-bootstrap." + ConfigProperties.OCP_PROJECT_DBZ + ".svc.cluster.local:9092")).put("database.history.kafka.topic", (Object)"schema-changes.inventory");
    }

    public ConnectorConfigBuilder postgresql(String dbServerName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder();
        String dbHost = ConfigProperties.DATABASE_POSTGRESQL_HOST.orElse("postgresql." + ConfigProperties.OCP_PROJECT_POSTGRESQL + ".svc.cluster.local");
        return cb.put("database.server.name", (Object)dbServerName).put("connector.class", (Object)"io.debezium.connector.postgresql.PostgresConnector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)ConfigProperties.DATABASE_POSTGRESQL_PORT).put("database.user", (Object)ConfigProperties.DATABASE_POSTGRESQL_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_POSTGRESQL_DBZ_PASSWORD).put("database.dbname", (Object)ConfigProperties.DATABASE_POSTGRESQL_DBZ_DBNAME).put("database.dbname", (Object)ConfigProperties.DATABASE_POSTGRESQL_DBZ_DBNAME).put("slot.name", (Object)"debezium").put("plugin.name", (Object)"pgoutput");
    }

    public ConnectorConfigBuilder sqlserver(String dbServerName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder();
        String dbHost = ConfigProperties.DATABASE_POSTGRESQL_HOST.orElse("sqlserver." + ConfigProperties.OCP_PROJECT_SQLSERVER + ".svc.cluster.local");
        return cb.put("database.server.name", (Object)dbServerName).put("connector.class", (Object)"io.debezium.connector.sqlserver.SqlServerConnector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)ConfigProperties.DATABASE_SQLSERVER_PORT).put("database.user", (Object)ConfigProperties.DATABASE_SQLSERVER_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_SQLSERVER_DBZ_PASSWORD).put("database.dbname", (Object)ConfigProperties.DATABASE_SQLSERVER_DBZ_DBNAME).put("database.history.kafka.bootstrap.servers", (Object)("debezium-kafka-cluster-kafka-bootstrap." + ConfigProperties.OCP_PROJECT_DBZ + ".svc.cluster.local:9092")).put("database.history.kafka.topic", (Object)"schema-changes.inventory");
    }

    public ConnectorConfigBuilder mongo(String dbServerName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder();
        String dbHost = ConfigProperties.DATABASE_MONGO_HOST.orElse("mongo." + ConfigProperties.OCP_PROJECT_MONGO + ".svc.cluster.local");
        return cb.put("mongodb.name", (Object)dbServerName).put("connector.class", (Object)"io.debezium.connector.mongodb.MongoDbConnector").put("task.max", (Object)1).put("mongodb.hosts", (Object)("rs0/" + dbHost + ":" + ConfigProperties.DATABASE_MONGO_PORT)).put("mongodb.user", (Object)ConfigProperties.DATABASE_MONGO_DBZ_USERNAME).put("mongodb.password", (Object)ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD);
    }

    public ConnectorConfigBuilder db2(String dbServerName) {
        ConnectorConfigBuilder cb = new ConnectorConfigBuilder();
        String dbHost = ConfigProperties.DATABASE_POSTGRESQL_HOST.orElse("db2." + ConfigProperties.OCP_PROJECT_DB2 + ".svc.cluster.local");
        return cb.put("database.server.name", (Object)dbServerName).put("connector.class", (Object)"io.debezium.connector.db2.Db2Connector").put("task.max", (Object)1).put("database.hostname", (Object)dbHost).put("database.port", (Object)ConfigProperties.DATABASE_DB2_PORT).put("database.user", (Object)ConfigProperties.DATABASE_DB2_DBZ_USERNAME).put("database.password", (Object)ConfigProperties.DATABASE_DB2_DBZ_PASSWORD).put("database.dbname", (Object)ConfigProperties.DATABASE_DB2_DBZ_DBNAME).put("database.cdcschema", (Object)"ASNCDC").put("database.history.kafka.bootstrap.servers", (Object)("debezium-kafka-cluster-kafka-bootstrap." + ConfigProperties.OCP_PROJECT_DBZ + ".svc.cluster.local:9092")).put("database.history.kafka.topic", (Object)"schema-changes.inventory");
    }
}

