/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift;

import io.debezium.testing.openshift.TestUtils;
import io.debezium.testing.openshift.assertions.AvroKafkaAssertions;
import io.debezium.testing.openshift.assertions.KafkaAssertions;
import io.debezium.testing.openshift.assertions.PlainKafkaAssertions;
import io.debezium.testing.openshift.resources.ConnectorFactories;
import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.kafka.KafkaController;
import io.debezium.testing.openshift.tools.kafka.OcpKafkaConnectController;
import io.debezium.testing.openshift.tools.kafka.OcpKafkaConnectDeployer;
import io.debezium.testing.openshift.tools.kafka.OcpKafkaController;
import io.debezium.testing.openshift.tools.kafka.OcpKafkaDeployer;
import io.debezium.testing.openshift.tools.kafka.StrimziOperatorController;
import io.debezium.testing.openshift.tools.registry.RegistryController;
import io.debezium.testing.openshift.tools.registry.RegistryDeployer;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectorTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorTestBase.class);
    protected static OpenShiftClient ocp;
    protected static TestUtils testUtils;
    protected static OkHttpClient httpClient;
    protected static KafkaAssertions assertions;
    public static final String KAFKA;
    public static final String KAFKA_CONNECT_S2I_LOGGING;
    public static final String KAFKA_CONNECT_S2I;
    public static final String REGISTRY_DEPLOYMENT_PATH = "/registry-resources/030-registry-streams.yaml";
    public static final String REGISTRY_STORAGE_TOPIC_PATH = "/registry-resources/010-storage-topic.yaml";
    public static final String REGISTRY_ID_TOPIC_PATH = "/registry-resources/020-global-id-topic.yaml";
    protected static Properties KAFKA_CONSUMER_PROPS;
    protected static KafkaController kafkaController;
    protected static OcpKafkaConnectController kafkaConnectController;
    protected static StrimziOperatorController operatorController;
    protected static ConnectorFactories connectorFactories;
    protected static RegistryDeployer registryDeployer;
    protected static RegistryController registryController;

    @BeforeAll
    public static void setup() throws InterruptedException {
        Config cfg = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(ConfigProperties.OCP_URL)).withUsername(ConfigProperties.OCP_USERNAME)).withPassword(ConfigProperties.OCP_PASSWORD)).withTrustCerts(true)).build();
        ocp = new DefaultOpenShiftClient(cfg);
        testUtils = new TestUtils();
        ConnectorTestBase.deployKafkaCluster();
        ConnectorTestBase.deployKafkaConnectCluster();
        if (ConfigProperties.DEPLOY_SERVICE_REGISTRY) {
            registryDeployer = new RegistryDeployer(ConfigProperties.OCP_PROJECT_REGISTRY, ocp, httpClient, (OcpKafkaController)kafkaController);
            registryController = registryDeployer.deployRegistry(REGISTRY_DEPLOYMENT_PATH, REGISTRY_STORAGE_TOPIC_PATH, REGISTRY_ID_TOPIC_PATH);
            assertions = new AvroKafkaAssertions(KAFKA_CONSUMER_PROPS);
        } else {
            assertions = new PlainKafkaAssertions(KAFKA_CONSUMER_PROPS);
        }
        ConnectorTestBase.initKafkaConsumerProps();
    }

    private static void deployKafkaCluster() throws InterruptedException {
        ConnectorTestBase.updateOperatorInNamespace(ConfigProperties.OCP_PROJECT_DBZ);
        OcpKafkaDeployer kafkaDeployer = new OcpKafkaDeployer.Builder().withOcpClient(ocp).withHttpClient(httpClient).withProject(ConfigProperties.OCP_PROJECT_DBZ).withYamlPath(KAFKA).build();
        kafkaController = kafkaDeployer.deploy();
    }

    private static void deployKafkaConnectCluster() throws InterruptedException {
        OcpKafkaConnectDeployer connectDeployer = new OcpKafkaConnectDeployer.Builder().withOcpClient(ocp).withHttpClient(httpClient).withProject(ConfigProperties.OCP_PROJECT_DBZ).withYamlPath(KAFKA_CONNECT_S2I).withCfgYamlPath(KAFKA_CONNECT_S2I_LOGGING).withConnectorResources(ConfigProperties.STRIMZI_OPERATOR_CONNECTORS).build();
        kafkaConnectController = connectDeployer.deploy();
        kafkaConnectController.allowServiceAccess();
        kafkaConnectController.exposeApi();
        kafkaConnectController.exposeMetrics();
    }

    private static void updateOperatorInNamespace(String project) throws InterruptedException {
        operatorController = StrimziOperatorController.forProject((String)project, (OpenShiftClient)ocp);
        operatorController.setLogLevel("DEBUG");
        operatorController.setAlwaysPullPolicy();
        operatorController.setOperandAlwaysPullPolicy();
        operatorController.setSingleReplica();
        ConfigProperties.OCP_PULL_SECRET_PATHS.ifPresent(paths -> {
            LOGGER.info("Processing pull secrets: " + paths);
            List<String> secrets = Arrays.stream(paths.split(",")).map(arg_0 -> ((StrimziOperatorController)operatorController).deployPullSecret(arg_0)).map(s -> s.getMetadata().getName()).collect(Collectors.toList());
            secrets.forEach(arg_0 -> ((StrimziOperatorController)operatorController).setImagePullSecret(arg_0));
            operatorController.setOperandImagePullSecrets(String.join((CharSequence)",", secrets));
        });
        operatorController.updateOperator();
    }

    private static void initKafkaConsumerProps() {
        KAFKA_CONSUMER_PROPS.put("bootstrap.servers", kafkaController.getKafkaBootstrapAddress());
        KAFKA_CONSUMER_PROPS.put("group.id", "DEBEZIUM_IT_01");
        KAFKA_CONSUMER_PROPS.put("auto.offset.reset", "earliest");
        KAFKA_CONSUMER_PROPS.put("enable.auto.commit", (Object)false);
    }

    @AfterAll
    public static void teardown() {
        ocp.close();
    }

    static {
        httpClient = new OkHttpClient();
        KAFKA = "/kafka-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/010-kafka.yaml";
        KAFKA_CONNECT_S2I_LOGGING = "/kafka-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/020-kafka-connect-cfg.yaml";
        KAFKA_CONNECT_S2I = "/kafka-resources/" + ConfigProperties.STRIMZI_CRD_VERSION + "/021-kafka-connect.yaml";
        KAFKA_CONSUMER_PROPS = new Properties();
        connectorFactories = new ConnectorFactories();
    }
}

