/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.mysql;

import io.debezium.testing.openshift.ConnectorTestBase;
import io.debezium.testing.openshift.assertions.KafkaAssertions;
import io.debezium.testing.openshift.resources.ConnectorFactories;
import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.databases.SqlDatabaseClient;
import io.debezium.testing.openshift.tools.databases.SqlDatabaseController;
import io.debezium.testing.openshift.tools.databases.mysql.MySqlDeployer;
import io.debezium.testing.openshift.tools.kafka.ConnectorConfigBuilder;
import java.io.IOException;
import java.sql.SQLException;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Tags(value={@Tag(value="acceptance"), @Tag(value="mysql")})
public class MySqlConnectorIT
extends ConnectorTestBase {
    public static final String DB_DEPLOYMENT_PATH = "/database-resources/mysql/deployment.yaml";
    public static final String DB_SERVICE_PATH_LB = "/database-resources/mysql/service-lb.yaml";
    public static final String DB_SERVICE_PATH = "/database-resources/mysql/service.yaml";
    public static final String CONNECTOR_NAME = "inventory-connector-mysql";
    private static SqlDatabaseController dbController;
    private static ConnectorFactories connectorFactories;
    private static ConnectorConfigBuilder connectorConfig;
    private static String connectorName;
    private static String dbServerName;

    @BeforeAll
    public static void setupDatabase() throws IOException, InterruptedException, ClassNotFoundException {
        Class.forName("com.mysql.cj.jdbc.Driver");
        if (!ConfigProperties.DATABASE_MYSQL_HOST.isPresent()) {
            dbController = (SqlDatabaseController)((MySqlDeployer)((MySqlDeployer)((MySqlDeployer)new MySqlDeployer(ocp).withProject(ConfigProperties.OCP_PROJECT_MYSQL)).withDeployment(DB_DEPLOYMENT_PATH)).withServices(new String[]{DB_SERVICE_PATH_LB, DB_SERVICE_PATH})).deploy();
        }
        connectorName = "inventory-connector-mysql-" + testUtils.getUniqueId();
        dbServerName = connectorName.replaceAll("-", "_");
        connectorConfig = connectorFactories.mysql(dbServerName);
        if (ConfigProperties.DEPLOY_SERVICE_REGISTRY) {
            connectorConfig.addApicurioAvroSupport(registryController.getRegistryApiAddress());
        }
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
    }

    @AfterAll
    public static void tearDownDatabase() throws IOException, InterruptedException {
        kafkaConnectController.undeployConnector(connectorName);
        dbController.reload();
    }

    private void insertCustomer(String firstName, String lastName, String email) throws SQLException {
        SqlDatabaseClient client = dbController.getDatabaseClient(ConfigProperties.DATABASE_MYSQL_USERNAME, ConfigProperties.DATABASE_MYSQL_PASSWORD);
        String sql = "INSERT INTO customers VALUES  (default, '" + firstName + "', '" + lastName + "', '" + email + "')";
        client.execute("inventory", sql);
    }

    @Test
    @Order(value=1)
    public void shouldHaveRegisteredConnector() {
        Request r = new Request.Builder().url(kafkaConnectController.getApiURL().resolve("/connectors")).build();
        KafkaAssertions.awaitAssert(() -> {
            try (Response res = httpClient.newCall(r).execute();){
                Assertions.assertThat((String)res.body().string()).contains(new CharSequence[]{connectorName});
            }
        });
    }

    @Test
    @Order(value=2)
    public void shouldCreateKafkaTopics() {
        assertions.assertTopicsExist(dbServerName + ".inventory.addresses", dbServerName + ".inventory.customers", dbServerName + ".inventory.geom", dbServerName + ".inventory.orders", dbServerName + ".inventory.products", dbServerName + ".inventory.products_on_hand");
    }

    @Test
    @Order(value=3)
    public void shouldSnapshotChanges() throws IOException {
        kafkaConnectController.waitForMySqlSnapshot(dbServerName);
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".inventory.customers", 4));
    }

    @Test
    @Order(value=4)
    public void shouldStreamChanges() throws SQLException {
        this.insertCustomer("Tom", "Tester", "tom@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".inventory.customers", 5));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(dbServerName + ".inventory.customers", "tom@test.com"));
    }

    @Test
    @Order(value=5)
    public void shouldBeDown() throws SQLException, IOException {
        kafkaConnectController.undeployConnector(connectorName);
        this.insertCustomer("Jerry", "Tester", "jerry@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".inventory.customers", 5));
    }

    @Test
    @Order(value=6)
    public void shouldResumeStreamingAfterRedeployment() throws IOException, InterruptedException {
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".inventory.customers", 6));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(dbServerName + ".inventory.customers", "jerry@test.com"));
    }

    @Test
    @Order(value=7)
    public void shouldBeDownAfterCrash() throws SQLException {
        operatorController.disable();
        kafkaConnectController.destroy();
        this.insertCustomer("Nibbles", "Tester", "nibbles@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(dbServerName + ".inventory.customers", 6));
    }

    @Test
    @Order(value=8)
    public void shouldResumeStreamingAfterCrash() throws InterruptedException {
        operatorController.enable();
        kafkaConnectController.waitForConnectCluster();
        KafkaAssertions.awaitAssert(() -> assertions.assertMinimalRecordsCount(dbServerName + ".inventory.customers", 7));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(dbServerName + ".inventory.customers", "nibbles@test.com"));
    }

    static {
        connectorFactories = new ConnectorFactories();
    }
}

