/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.assertions;

import io.debezium.testing.openshift.assertions.KafkaAssertions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.assertj.core.api.Assertions;

public class AvroKafkaAssertions
implements KafkaAssertions<byte[], byte[]> {
    private final Properties kafkaConsumerProps;

    public AvroKafkaAssertions(Properties kafkaConsumerProps) {
        this.kafkaConsumerProps = kafkaConsumerProps;
        kafkaConsumerProps.put("key.deserializer", ByteArrayDeserializer.class);
        kafkaConsumerProps.put("value.deserializer", ByteArrayDeserializer.class);
    }

    @Override
    public Consumer<byte[], byte[]> getConsumer() {
        return new KafkaConsumer(this.kafkaConsumerProps);
    }

    @Override
    public void assertRecordsContain(String topic, String content) {
        try (Consumer<byte[], byte[]> consumer = this.getConsumer();){
            consumer.subscribe(Collections.singleton(topic));
            consumer.seekToBeginning((Collection)consumer.assignment());
            ConsumerRecords records = consumer.poll(Duration.of(10L, ChronoUnit.SECONDS));
            StreamSupport.stream(records.records(topic).spliterator(), false).forEach(r -> {
                Assertions.assertThat((byte)((byte[])r.key())[0]).isZero();
                Assertions.assertThat((byte)((byte[])r.value())[0]).isZero();
            });
        }
    }
}

