/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.sqlserver;

import io.debezium.testing.openshift.ConnectorTestBase;
import io.debezium.testing.openshift.assertions.KafkaAssertions;
import io.debezium.testing.openshift.resources.ConnectorFactories;
import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.databases.SqlDatabaseClient;
import io.debezium.testing.openshift.tools.databases.sqlserver.SqlServerController;
import io.debezium.testing.openshift.tools.databases.sqlserver.SqlServerDeployer;
import io.debezium.testing.openshift.tools.kafka.ConnectorConfigBuilder;
import java.io.IOException;
import java.sql.SQLException;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Tags(value={@Tag(value="acceptance"), @Tag(value="sqlserver")})
public class SqlServerConnectorIT
extends ConnectorTestBase {
    public static final String DB_DEPLOYMENT_PATH = "/database-resources/sqlserver/deployment.yaml";
    public static final String DB_SERVICE_PATH_LB = "/database-resources/sqlserver/service-lb.yaml";
    public static final String DB_SERVICE_PATH = "/database-resources/sqlserver/service.yaml";
    public static final String CONNECTOR_NAME = "inventory-connector-sqlserver";
    private static SqlServerDeployer dbDeployer;
    private static SqlServerController dbController;
    private static ConnectorFactories connectorFactories;
    private static ConnectorConfigBuilder connectorConfig;
    private static String connectorName;

    @BeforeAll
    public static void setupDatabase() throws IOException, InterruptedException, ClassNotFoundException {
        if (!ConfigProperties.DATABASE_SQLSERVER_HOST.isPresent()) {
            dbDeployer = (SqlServerDeployer)((SqlServerDeployer)((SqlServerDeployer)new SqlServerDeployer(ocp).withProject(ConfigProperties.OCP_PROJECT_SQLSERVER)).withDeployment(DB_DEPLOYMENT_PATH)).withServices(new String[]{DB_SERVICE_PATH_LB, DB_SERVICE_PATH});
            dbController = (SqlServerController)dbDeployer.deploy();
            dbController.initialize();
        }
        String id = testUtils.getUniqueId();
        connectorName = "inventory-connector-sqlserver-" + id;
        connectorConfig = connectorFactories.sqlserver().put("database.server.name", (Object)connectorName);
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    @AfterAll
    public static void tearDownDatabase() throws IOException, InterruptedException {
        kafkaConnectController.undeployConnector(connectorName);
        dbController.reload();
    }

    private void insertCustomer(String firstName, String lastName, String email) throws SQLException {
        SqlDatabaseClient client = dbController.getDatabaseClient(ConfigProperties.DATABASE_SQLSERVER_DBZ_USERNAME, ConfigProperties.DATABASE_SQLSERVER_DBZ_PASSWORD);
        String sql = "INSERT INTO customers (first_name, last_name, email) VALUES ('" + firstName + "', '" + lastName + "', '" + email + "')";
        client.execute(ConfigProperties.DATABASE_SQLSERVER_DBZ_DBNAME, sql);
    }

    @Test
    @Order(value=1)
    public void shouldHaveRegisteredConnector() {
        Request r = new Request.Builder().url(kafkaConnectController.getApiURL().resolve("/connectors")).build();
        KafkaAssertions.awaitAssert(() -> {
            try (Response res = httpClient.newCall(r).execute();){
                Assertions.assertThat((String)res.body().string()).contains(new CharSequence[]{connectorName});
            }
        });
    }

    @Test
    @Order(value=2)
    public void shouldCreateKafkaTopics() {
        assertions.assertTopicsExist(connectorName + ".dbo.customers", connectorName + ".dbo.orders", connectorName + ".dbo.products", connectorName + ".dbo.products_on_hand");
    }

    @Test
    @Order(value=3)
    public void shouldContainRecordsInCustomersTopic() throws IOException {
        kafkaConnectController.waitForSqlServerSnapshot(connectorName);
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(connectorName + ".dbo.customers", 4));
    }

    @Test
    @Order(value=4)
    public void shouldStreamChanges() throws SQLException {
        this.insertCustomer("Tom", "Tester", "tom@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(connectorName + ".dbo.customers", 5));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(connectorName + ".dbo.customers", "tom@test.com"));
    }

    @Test
    @Order(value=5)
    public void shouldBeDown() throws SQLException, IOException {
        kafkaConnectController.undeployConnector(connectorName);
        this.insertCustomer("Jerry", "Tester", "jerry@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(connectorName + ".dbo.customers", 5));
    }

    @Test
    @Order(value=6)
    public void shouldResumeStreamingAfterRedeployment() throws IOException, InterruptedException {
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(connectorName + ".dbo.customers", 6));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(connectorName + ".dbo.customers", "jerry@test.com"));
    }

    @Test
    @Order(value=7)
    public void shouldBeDownAfterCrash() throws SQLException {
        operatorController.disable();
        kafkaConnectController.destroy();
        this.insertCustomer("Nibbles", "Tester", "nibbles@test.com");
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsCount(connectorName + ".dbo.customers", 6));
    }

    @Test
    @Order(value=8)
    public void shouldResumeStreamingAfterCrash() throws InterruptedException {
        operatorController.enable();
        kafkaConnectController.waitForConnectCluster();
        KafkaAssertions.awaitAssert(() -> assertions.assertMinimalRecordsCount(connectorName + ".dbo.customers", 7));
        KafkaAssertions.awaitAssert(() -> assertions.assertRecordsContain(connectorName + ".dbo.customers", "nibbles@test.com"));
    }

    static {
        connectorFactories = new ConnectorFactories();
    }
}

