/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.apicurio.registry.operator.api.model.DoneableApicurioRegistry;
import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.debezium.testing.openshift.tools.OperatorController;
import io.debezium.testing.openshift.tools.WaitConditions;
import io.debezium.testing.openshift.tools.YAML;
import io.debezium.testing.openshift.tools.kafka.KafkaController;
import io.debezium.testing.openshift.tools.registry.RegistryController;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryDeployer.class);
    private final OpenShiftClient ocp;
    private final OkHttpClient http;
    private final OpenShiftUtils ocpUtils;
    private final String project;
    private final KafkaController kafkaController;

    public RegistryDeployer(String project, OpenShiftClient ocp, OkHttpClient http, KafkaController kafkaController) {
        this.project = project;
        this.ocp = ocp;
        this.http = http;
        this.ocpUtils = new OpenShiftUtils(ocp);
        this.kafkaController = kafkaController;
    }

    public OperatorController getOperator() {
        Deployment operator = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName("apicurio-registry-operator")).get();
        return new OperatorController(operator, Collections.singletonMap("name", "apicurio-registry-operator"), this.ocp);
    }

    public RegistryController deployRegistry(String yamlPath, String storageTopicYamlPath, String idTopicYamlPath) throws InterruptedException {
        LOGGER.info("Deploying Apicurio Registry from " + yamlPath);
        this.kafkaController.deployTopic(storageTopicYamlPath);
        this.kafkaController.deployTopic(idTopicYamlPath);
        ApicurioRegistry registry = YAML.fromResource(yamlPath, ApicurioRegistry.class);
        registry = (ApicurioRegistry)this.registryOperation().createOrReplace((Object[])new ApicurioRegistry[]{registry});
        registry = this.waitForRegistry(registry.getMetadata().getName());
        return new RegistryController(registry, this.ocp, this.http);
    }

    public NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, DoneableApicurioRegistry, Resource<ApicurioRegistry, DoneableApicurioRegistry>> registryOperation() {
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.ocp.customResourceDefinitions().load(RegistryDeployer.class.getResourceAsStream("/crds/apicur.io_apicurioregistries_crd.yaml"))).get();
        KubernetesDeserializer.registerCustomKind((String)"apicur.io/v1alpha1", (String)"ApicurioRegistry", ApicurioRegistry.class);
        return (NonNamespaceOperation)this.ocp.customResources(crd, ApicurioRegistry.class, ApicurioRegistryList.class, DoneableApicurioRegistry.class).inNamespace(this.project);
    }

    public ApicurioRegistry waitForRegistry(String name) throws InterruptedException {
        LOGGER.info("Waiting for deployments of registry '" + name + "'");
        Awaitility.await().atMost(WaitConditions.scaled(1L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> !this.getRegistryDeployments(name).isEmpty());
        DeploymentConfig dc = this.getRegistryDeployments(name).get(0);
        ((DeployableScalableResource)((NonNamespaceOperation)this.ocp.deploymentConfigs().inNamespace(this.project)).withName(dc.getMetadata().getName())).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
        return (ApicurioRegistry)((Resource)this.registryOperation().withName(name)).get();
    }

    private List<DeploymentConfig> getRegistryDeployments(String name) {
        return ((DeploymentConfigList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.deploymentConfigs().inNamespace(this.project)).withLabel("app", name)).list()).getItems();
    }
}

