/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift;

import io.debezium.testing.openshift.TestUtils;
import io.debezium.testing.openshift.assertions.AvroKafkaAssertions;
import io.debezium.testing.openshift.assertions.KafkaAssertions;
import io.debezium.testing.openshift.assertions.PlainKafkaAssertions;
import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.kafka.KafkaConnectController;
import io.debezium.testing.openshift.tools.kafka.KafkaController;
import io.debezium.testing.openshift.tools.kafka.KafkaDeployer;
import io.debezium.testing.openshift.tools.kafka.OperatorController;
import io.debezium.testing.openshift.tools.registry.RegistryController;
import io.debezium.testing.openshift.tools.registry.RegistryDeployer;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectorTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorTestBase.class);
    protected static OpenShiftClient ocp;
    protected static TestUtils testUtils;
    protected static OkHttpClient httpClient;
    protected static KafkaAssertions assertions;
    public static final String KAFKA = "/kafka-resources/010-kafka.yaml";
    public static final String KAFKA_CONNECT_S2I_LOGGING = "/kafka-resources/020-kafka-connect-logging.yaml";
    public static final String KAFKA_CONNECT_S2I = "/kafka-resources/021-kafka-connect.yaml";
    public static final String REGISTRY_DEPLOYMENT_PATH = "/registry-resources/030-registry-streams.yaml";
    public static final String REGISTRY_STORAGE_TOPIC_PATH = "/registry-resources/010-storage-topic.yaml";
    public static final String REGISTRY_ID_TOPIC_PATH = "/registry-resources/020-global-id-topic.yaml";
    protected static Properties KAFKA_CONSUMER_PROPS;
    protected static KafkaDeployer kafkaDeployer;
    protected static KafkaController kafkaController;
    protected static KafkaConnectController kafkaConnectController;
    protected static OperatorController operatorController;
    protected static RegistryDeployer registryDeployer;
    protected static RegistryController registryController;

    @BeforeAll
    public static void setup() throws InterruptedException {
        Config cfg = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(ConfigProperties.OCP_URL)).withUsername(ConfigProperties.OCP_USERNAME)).withPassword(ConfigProperties.OCP_PASSWORD)).withTrustCerts(true)).build();
        ocp = new DefaultOpenShiftClient(cfg);
        testUtils = new TestUtils();
        ConnectorTestBase.deployKafkaCluster();
        ConnectorTestBase.initKafkaConsumerProps();
        if (ConfigProperties.DEPLOY_SERVICE_REGISTRY) {
            registryDeployer = new RegistryDeployer(ConfigProperties.OCP_PROJECT_REGISTRY, ocp, httpClient, kafkaController);
            registryController = registryDeployer.deployRegistry(REGISTRY_DEPLOYMENT_PATH, REGISTRY_STORAGE_TOPIC_PATH, REGISTRY_ID_TOPIC_PATH);
            assertions = new AvroKafkaAssertions(KAFKA_CONSUMER_PROPS);
        } else {
            assertions = new PlainKafkaAssertions(KAFKA_CONSUMER_PROPS);
        }
    }

    private static void deployKafkaCluster() throws InterruptedException {
        kafkaDeployer = new KafkaDeployer(ConfigProperties.OCP_PROJECT_DBZ, ocp);
        operatorController = kafkaDeployer.getOperator();
        operatorController.setLogLevel("DEBUG");
        operatorController.setAlwaysPullPolicy();
        operatorController.setOperandAlwaysPullPolicy();
        operatorController.setSingleReplica();
        if (ConfigProperties.OCP_PULL_SECRET_PATHS.isPresent()) {
            String paths = (String)ConfigProperties.OCP_PULL_SECRET_PATHS.get();
            LOGGER.info("Processing pull secrets: " + paths);
            List<String> secrets = Arrays.stream(paths.split(",")).map(arg_0 -> ((KafkaDeployer)kafkaDeployer).deployPullSecret(arg_0)).map(s -> s.getMetadata().getName()).collect(Collectors.toList());
            secrets.forEach(arg_0 -> ((OperatorController)operatorController).setImagePullSecret(arg_0));
            operatorController.setOperandImagePullSecrets(String.join((CharSequence)",", secrets));
        }
        operatorController.updateOperator();
        kafkaController = kafkaDeployer.deployKafkaCluster(KAFKA);
        kafkaConnectController = kafkaDeployer.deployKafkaConnectCluster(KAFKA_CONNECT_S2I, KAFKA_CONNECT_S2I_LOGGING, ConfigProperties.STRIMZI_OPERATOR_CONNECTORS);
        kafkaConnectController.allowServiceAccess();
        kafkaConnectController.exposeApi();
        kafkaConnectController.exposeMetrics();
    }

    private static void initKafkaConsumerProps() {
        KAFKA_CONSUMER_PROPS.put("bootstrap.servers", kafkaController.getKafkaBootstrapAddress());
        KAFKA_CONSUMER_PROPS.put("group.id", "DEBEZIUM_IT_01");
        KAFKA_CONSUMER_PROPS.put("auto.offset.reset", "earliest");
        KAFKA_CONSUMER_PROPS.put("enable.auto.commit", (Object)false);
    }

    @AfterAll
    public static void teardown() {
        ocp.close();
    }

    static {
        httpClient = new OkHttpClient();
        KAFKA_CONSUMER_PROPS = new Properties();
    }
}

