/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases.db2;

import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.databases.SqlDatabaseClient;
import io.debezium.testing.openshift.tools.databases.SqlDatabaseController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2Controller
extends SqlDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DB2Controller.class);
    private static final String READINESS_SQL_SELECT = "SELECT 1 FROM DB2INST1.CUSTOMERS;";

    public DB2Controller(Deployment deployment, List<Service> services, String dbType, OpenShiftClient ocp) {
        super(deployment, services, dbType, ocp);
    }

    @Override
    public void initialize() {
        LOGGER.info("Waiting until DB2 instance is ready");
        SqlDatabaseClient client = this.getDatabaseClient(ConfigProperties.DATABASE_DB2_DBZ_USERNAME, ConfigProperties.DATABASE_DB2_DBZ_PASSWORD);
        try {
            client.execute(READINESS_SQL_SELECT);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String constructDatabaseUrl(String hostname, int port) {
        return super.constructDatabaseUrl(hostname, port) + ConfigProperties.DATABASE_DB2_DBZ_DBNAME;
    }

    private String getLog(String podName) {
        return (String)((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(podName)).getLog();
    }
}

