/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.debezium.testing.openshift.tools.WaitConditions;
import io.debezium.testing.openshift.tools.databases.Commands;
import io.debezium.testing.openshift.tools.databases.DatabaseClient;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.bson.Document;

public class MongoDatabaseClient
implements DatabaseClient<MongoClient, RuntimeException> {
    private String url;
    private String username;
    private String password;
    private String authSource;

    public MongoDatabaseClient(String url, String username, String password, String authSource) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.authSource = authSource;
    }

    private boolean doExecute(Commands<MongoClient, RuntimeException> commands) throws RuntimeException {
        MongoCredential credential = MongoCredential.createCredential((String)this.username, (String)this.authSource, (char[])this.password.toCharArray());
        ConnectionString connString = new ConnectionString(this.url);
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(connString).credential(credential).retryWrites(true).build();
        MongoClient client = MongoClients.create((MongoClientSettings)settings);
        commands.execute(client);
        return true;
    }

    @Override
    public void execute(Commands<MongoClient, RuntimeException> commands) throws RuntimeException {
        Awaitility.await().atMost(WaitConditions.scaled(2L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).ignoreExceptions().until(() -> this.doExecute(commands));
    }

    public void execute(String database, Commands<MongoDatabase, RuntimeException> commands) {
        this.execute((MongoClient con) -> {
            MongoDatabase db = con.getDatabase(database);
            commands.execute(db);
        });
    }

    public void execute(String database, String collection, Commands<MongoCollection<Document>, RuntimeException> commands) {
        this.execute(database, db -> {
            MongoCollection col = db.getCollection(collection);
            commands.execute(col);
        });
    }
}

