/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.kafka;

import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.status.ListenerAddress;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import java.util.List;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaController {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaController.class);
    private final Kafka kafka;
    private final OpenShiftClient ocp;
    private final OkHttpClient http;
    private final String project;
    private final OpenShiftUtils ocpUtils;

    public KafkaController(Kafka kafka, OpenShiftClient ocp, OkHttpClient http) {
        this.kafka = kafka;
        this.ocp = ocp;
        this.http = http;
        this.project = kafka.getMetadata().getNamespace();
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public String getKafkaBootstrapAddress() {
        List listeners = this.kafka.getStatus().getListeners();
        ListenerStatus listener = listeners.stream().filter(l -> l.getType().equalsIgnoreCase("external")).findAny().orElseThrow(() -> new IllegalStateException("No external listener found for Kafka cluster " + this.kafka.getMetadata().getName()));
        ListenerAddress address = (ListenerAddress)listener.getAddresses().get(0);
        return address.getHost() + ":" + address.getPort();
    }

    public boolean undeployCluster() {
        return (Boolean)Crds.kafkaOperation((KubernetesClient)this.ocp).delete((Object[])new Kafka[]{this.kafka});
    }
}

