/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases;

import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.debezium.testing.openshift.tools.WaitConditions;
import io.debezium.testing.openshift.tools.databases.DatabaseClient;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseController<C extends DatabaseClient<?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseController.class);
    protected final OpenShiftClient ocp;
    protected final String project;
    protected final String dbType;
    protected final OpenShiftUtils ocpUtils;
    protected Deployment deployment;
    protected String name;
    protected List<Service> services;

    public DatabaseController(Deployment deployment, List<Service> services, String dbType, OpenShiftClient ocp) {
        this.deployment = deployment;
        this.name = deployment.getMetadata().getName();
        this.project = deployment.getMetadata().getNamespace();
        this.services = services;
        this.ocp = ocp;
        this.dbType = dbType;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public String getDatabaseUrl() {
        Service svc = (Service)((ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName(this.deployment.getMetadata().getName() + "-lb")).get();
        LoadBalancerIngress ingress = (LoadBalancerIngress)svc.getStatus().getLoadBalancer().getIngress().get(0);
        String hostname = ingress.getHostname();
        Integer port = svc.getSpec().getPorts().stream().filter(p -> p.getName().equals("db")).findAny().get().getPort();
        return this.constructDatabaseUrl(hostname, port);
    }

    public void reload() throws InterruptedException {
        LOGGER.info("Recreating all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        ((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabel("deployment", this.name)).delete();
        this.deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
        LOGGER.info("Deployment '" + this.name + "' is available");
        this.initialize();
    }

    public abstract void initialize() throws InterruptedException;

    public abstract C getDatabaseClient(String var1, String var2);

    protected abstract String constructDatabaseUrl(String var1, int var2);
}

