/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.mongodb;

import io.debezium.testing.openshift.ConnectorTestBase;
import io.debezium.testing.openshift.resources.ConnectorFactories;
import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.databases.mongodb.MongoController;
import io.debezium.testing.openshift.tools.databases.mongodb.MongoDatabaseClient;
import io.debezium.testing.openshift.tools.databases.mongodb.MongoDeployer;
import io.debezium.testing.openshift.tools.kafka.ConnectorConfigBuilder;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Tags(value={@Tag(value="acceptance"), @Tag(value="mongo")})
public class MongoConnectorIT
extends ConnectorTestBase {
    public static final String DB_DEPLOYMENT_PATH = "/database-resources/mongodb/deployment.yaml";
    public static final String DB_SERVICE_PATH_LB = "/database-resources/mongodb/service-lb.yaml";
    public static final String DB_SERVICE_PATH = "/database-resources/mongodb/service.yaml";
    public static final String CONNECTOR_NAME = "inventory-connector-mongo";
    private static MongoDeployer dbDeployer;
    private static MongoController dbController;
    private static OkHttpClient httpClient;
    private static ConnectorFactories connectorFactories;
    private static ConnectorConfigBuilder connectorConfig;
    private static String connectorName;

    @BeforeAll
    public static void setupDatabase() throws IOException, InterruptedException {
        if (!ConfigProperties.DATABASE_MONGO_HOST.isPresent()) {
            dbDeployer = (MongoDeployer)((MongoDeployer)((MongoDeployer)new MongoDeployer(ocp).withProject(ConfigProperties.OCP_PROJECT_MONGO)).withDeployment(DB_DEPLOYMENT_PATH)).withServices(new String[]{DB_SERVICE_PATH_LB, DB_SERVICE_PATH});
            dbController = (MongoController)dbDeployer.deploy();
            dbController.initialize();
        }
        String id = testUtils.getUniqueId();
        connectorName = "inventory-connector-mongo-" + id;
        connectorConfig = connectorFactories.mongo().put("mongodb.name", (Object)connectorName);
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
    }

    @AfterAll
    public static void tearDownDatabase() throws IOException, InterruptedException {
        kafkaConnectController.undeployConnector(connectorName);
        dbController.reload();
    }

    private void insertCustomer(String firstName, String lastName, String email) {
        MongoDatabaseClient client = dbController.getDatabaseClient(ConfigProperties.DATABASE_MONGO_DBZ_USERNAME, ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD, ConfigProperties.DATABASE_MONGO_DBZ_LOGIN_DBNAME);
        client.execute(ConfigProperties.DATABASE_MONGO_DBZ_DBNAME, "customers", col -> {
            Document doc = new Document().append("first_name", (Object)firstName).append("last_name", (Object)lastName).append("email", (Object)email);
            col.insertOne((Object)doc);
        });
    }

    @Test
    @Order(value=1)
    public void shouldHaveRegisteredConnector() {
        Request r = new Request.Builder().url(kafkaConnectController.getApiURL().resolve("/connectors")).build();
        this.awaitAssert(() -> {
            try (Response res = httpClient.newCall(r).execute();){
                Assertions.assertThat((String)res.body().string()).contains(new CharSequence[]{connectorName});
            }
        });
    }

    @Test
    @Order(value=2)
    public void shouldCreateKafkaTopics() {
        this.assertTopicsExist(connectorName + ".inventory.customers", connectorName + ".inventory.orders", connectorName + ".inventory.products");
    }

    @Test
    @Order(value=3)
    public void shouldContainRecordsInCustomersTopic() throws IOException {
        kafkaConnectController.waitForMongoSnapshot(connectorName);
        this.awaitAssert(() -> this.assertRecordsCount(connectorName + ".inventory.customers", 4));
    }

    @Test
    @Order(value=4)
    public void shouldStreamChanges() {
        this.insertCustomer("Tom", "Tester", "tom@test.com");
        this.awaitAssert(() -> this.assertRecordsCount(connectorName + ".inventory.customers", 5));
        this.awaitAssert(() -> this.assertRecordsContain(connectorName + ".inventory.customers", "tom@test.com"));
    }

    @Test
    @Order(value=5)
    public void shouldBeDown() throws IOException {
        kafkaConnectController.undeployConnector(connectorName);
        this.insertCustomer("Jerry", "Tester", "jerry@test.com");
        this.awaitAssert(() -> this.assertRecordsCount(connectorName + ".inventory.customers", 5));
    }

    @Test
    @Order(value=6)
    public void shouldResumeStreamingAfterRedeployment() throws IOException, InterruptedException {
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
        this.awaitAssert(() -> this.assertRecordsCount(connectorName + ".inventory.customers", 6));
        this.awaitAssert(() -> this.assertRecordsContain(connectorName + ".inventory.customers", "jerry@test.com"));
    }

    @Test
    @Order(value=7)
    public void shouldBeDownAfterCrash() {
        operatorController.disable();
        kafkaConnectController.destroy();
        this.insertCustomer("Nibbles", "Tester", "nibbles@test.com");
        this.awaitAssert(() -> this.assertRecordsCount(connectorName + ".inventory.customers", 6));
    }

    @Test
    @Order(value=8)
    public void shouldResumeStreamingAfterCrash() throws InterruptedException {
        operatorController.enable();
        kafkaConnectController.waitForConnectCluster();
        this.awaitAssert(() -> this.assertMinimalRecordsCount(connectorName + ".inventory.customers", 7));
        this.awaitAssert(() -> this.assertRecordsContain(connectorName + ".inventory.customers", "nibbles@test.com"));
    }

    static {
        httpClient = new OkHttpClient();
        connectorFactories = new ConnectorFactories();
    }
}

