/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases;

import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseController.class);
    private final OpenShiftClient ocp;
    private final String project;
    private final String dbType;
    private final OpenShiftUtils ocpUtils;
    private Deployment deployment;
    private String name;
    private List<Service> services;

    public DatabaseController(Deployment deployment, List<Service> services, String dbType, OpenShiftClient ocp) {
        this.deployment = deployment;
        this.name = deployment.getMetadata().getName();
        this.project = deployment.getMetadata().getNamespace();
        this.services = services;
        this.ocp = ocp;
        this.dbType = dbType;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public String getDatabaseUrl() {
        Service svc = (Service)((ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName(this.deployment.getMetadata().getName() + "-lb")).get();
        LoadBalancerIngress ingress = (LoadBalancerIngress)svc.getStatus().getLoadBalancer().getIngress().get(0);
        String hostname = ingress.getHostname();
        Integer port = svc.getSpec().getPorts().stream().filter(p -> p.getName().equals("db")).findAny().get().getPort();
        return "jdbc:" + this.dbType + "://" + hostname + ":" + port + "/";
    }

    public void executeStatement(String database, String username, String password, String sql) throws SQLException {
        try (Connection con = DriverManager.getConnection(this.getDatabaseUrl(), username, password);){
            con.setCatalog(database);
            Statement stmt = con.createStatement();
            stmt.execute(sql);
        }
    }

    public void reload() throws InterruptedException {
        LOGGER.info("Recreating all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        ((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabel("deployment", this.name)).delete();
        this.deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).waitUntilCondition(this::deploymentAvailableCondition, 30L, TimeUnit.SECONDS);
        LOGGER.info("Deployment '" + this.name + "' is available");
    }

    private boolean deploymentAvailableCondition(Deployment d) {
        return d.getStatus() != null && d.getStatus().getConditions().stream().anyMatch(c -> c.getType().equalsIgnoreCase("Available") && c.getStatus().equalsIgnoreCase("true"));
    }
}

