/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.mysql;

import io.debezium.testing.openshift.ConnectorTestBase;
import io.debezium.testing.openshift.resources.ConfigProperties;
import io.debezium.testing.openshift.resources.ConnectorFactories;
import io.debezium.testing.openshift.tools.databases.DatabaseController;
import io.debezium.testing.openshift.tools.databases.MySqlDeployer;
import io.debezium.testing.openshift.tools.kafka.ConnectorConfigBuilder;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Tags(value={@Tag(value="acceptance"), @Tag(value="mysql")})
public class MySqlConnectorIT
extends ConnectorTestBase {
    public static final String DB_DEPLOYMENT_PATH = "/database-resources/mysql/deployment.yaml";
    public static final String DB_SERVICE_PATH_LB = "/database-resources/mysql/service-lb.yaml";
    public static final String DB_SERVICE_PATH = "/database-resources/mysql/service.yaml";
    public static final String CONNECTOR_NAME = "inventory-connector-mysql";
    private static MySqlDeployer dbDeployer;
    private static DatabaseController dbController;
    private static OkHttpClient httpClient;
    private static ConnectorFactories connectorFactories;
    private static ConnectorConfigBuilder connectorConfig;
    private static String connectorName;

    @BeforeAll
    public static void setupDatabase() throws IOException, InterruptedException, ClassNotFoundException {
        if (!ConfigProperties.DATABASE_MYSQL_HOST.isPresent()) {
            dbDeployer = (MySqlDeployer)((MySqlDeployer)((MySqlDeployer)new MySqlDeployer(ocp).withProject(ConfigProperties.OCP_PROJECT_MYSQL)).withDeployment(DB_DEPLOYMENT_PATH)).withServices(new String[]{DB_SERVICE_PATH_LB, DB_SERVICE_PATH});
            dbController = dbDeployer.deploy();
        }
        connectorName = "inventory-connector-mysql-" + testUtils.getUniqueId();
        connectorConfig = connectorFactories.mysql().put("database.server.name", (Object)connectorName);
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
        Class.forName("com.mysql.cj.jdbc.Driver");
    }

    @AfterAll
    public static void tearDownDatabase() throws IOException, InterruptedException {
        kafkaConnectController.undeployConnector(connectorName);
        dbController.reload();
    }

    @Test
    @Order(value=1)
    public void shouldHaveRegisteredConnector() {
        Request r = new Request.Builder().url(kafkaConnectController.getApiURL().resolve("/connectors")).build();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> {
            try (Response res = httpClient.newCall(r).execute();){
                Assertions.assertThat((String)res.body().string()).contains(new CharSequence[]{connectorName});
            }
        });
    }

    @Test
    @Order(value=2)
    public void shouldCreateKafkaTopics() {
        this.assertTopicsExist(connectorName + ".inventory.addresses", connectorName + ".inventory.customers", connectorName + ".inventory.geom", connectorName + ".inventory.orders", connectorName + ".inventory.products", connectorName + ".inventory.products_on_hand");
    }

    @Test
    @Order(value=3)
    public void shouldSnapshotChanges() throws IOException {
        kafkaConnectController.waitForMySqlSnapshot(connectorName);
        this.assertRecordsCount(connectorName + ".inventory.customers", 4);
    }

    @Test
    @Order(value=4)
    public void shouldStreamChanges() throws SQLException {
        String sql = "INSERT INTO customers VALUES  (default, 'Tom', 'Tester', 'tom@test.com')";
        dbController.executeStatement("inventory", ConfigProperties.DATABASE_MYSQL_USERNAME, ConfigProperties.DATABASE_MYSQL_PASSWORD, sql);
        this.assertRecordsCount(connectorName + ".inventory.customers", 5);
        this.assertRecordsContain(connectorName + ".inventory.customers", "tom@test.com");
    }

    @Test
    @Order(value=5)
    public void shouldBeDown() throws SQLException, IOException {
        kafkaConnectController.undeployConnector(connectorName);
        String sql = "INSERT INTO customers VALUES  (default, 'Jerry', 'Tester', 'jerry@test.com')";
        dbController.executeStatement("inventory", ConfigProperties.DATABASE_MYSQL_USERNAME, ConfigProperties.DATABASE_MYSQL_PASSWORD, sql);
        this.assertRecordsCount(connectorName + ".inventory.customers", 5);
    }

    @Test
    @Order(value=6)
    public void shouldResumeStreamingAfterRedeployment() throws IOException, InterruptedException {
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(5L, TimeUnit.SECONDS).untilAsserted(() -> this.assertRecordsCount(connectorName + ".inventory.customers", 6));
        this.assertRecordsContain(connectorName + ".inventory.customers", "jerry@test.com");
    }

    @Test
    @Order(value=7)
    public void shouldBeDownAfterCrash() throws SQLException {
        operatorController.disable();
        kafkaConnectController.destroy();
        String sql = "INSERT INTO customers VALUES  (default, 'Nibbles', 'Tester', 'nibbles@test.com')";
        dbController.executeStatement("inventory", ConfigProperties.DATABASE_MYSQL_USERNAME, ConfigProperties.DATABASE_MYSQL_PASSWORD, sql);
        this.assertRecordsCount(connectorName + ".inventory.customers", 6);
    }

    @Test
    @Order(value=8)
    public void shouldResumeStreamingAfterCrash() throws InterruptedException {
        operatorController.enable();
        kafkaConnectController.waitForConnectCluster();
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(5L, TimeUnit.SECONDS).untilAsserted(() -> this.assertMinimalRecordsCount(connectorName + ".inventory.customers", 7));
        this.assertRecordsContain(connectorName + ".inventory.customers", "nibbles@test.com");
    }

    static {
        httpClient = new OkHttpClient();
        connectorFactories = new ConnectorFactories();
    }
}

