/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.kafka;

import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.debezium.testing.openshift.tools.YAML;
import io.debezium.testing.openshift.tools.kafka.KafkaConnectController;
import io.debezium.testing.openshift.tools.kafka.KafkaController;
import io.debezium.testing.openshift.tools.kafka.OperatorController;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaConnectList;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.model.DoneableKafka;
import io.strimzi.api.kafka.model.DoneableKafkaConnect;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectBuilder;
import io.strimzi.api.kafka.model.KafkaConnectFluent;
import io.strimzi.api.kafka.model.status.HasStatus;
import io.strimzi.api.kafka.model.status.Status;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaDeployer.class);
    private final OpenShiftClient ocp;
    private final OkHttpClient http;
    private final OpenShiftUtils ocpUtils;
    private final String project;

    public KafkaDeployer(String project, OpenShiftClient ocp, OkHttpClient http) {
        this.project = project;
        this.ocp = ocp;
        this.http = http;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public KafkaDeployer(String project, OpenShiftClient ocp) {
        this(project, ocp, new OkHttpClient());
    }

    public OperatorController getOperator() {
        Deployment operator = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName("strimzi-cluster-operator")).get();
        return new OperatorController(operator, this.ocp);
    }

    public KafkaController deployKafkaCluster(String yamlPath) throws InterruptedException {
        LOGGER.info("Deploying Kafka from " + yamlPath);
        Kafka kafka = (Kafka)this.kafkaOperation().createOrReplace((Object[])new Kafka[]{YAML.fromResource(yamlPath, Kafka.class)});
        kafka = this.waitForKafkaCluster(kafka.getMetadata().getName());
        return new KafkaController(kafka, this.ocp, this.http);
    }

    public KafkaConnectController deployKafkaConnectCluster(String yamlPath, String loggingYamlPath, boolean useConnectorResources) throws InterruptedException {
        LOGGER.info("Deploying KafkaConnect from " + yamlPath);
        ((NonNamespaceOperation)this.ocp.configMaps().inNamespace(this.project)).createOrReplace((Object[])new ConfigMap[]{YAML.fromResource(loggingYamlPath, ConfigMap.class)});
        KafkaConnect kafkaConnect = YAML.fromResource(yamlPath, KafkaConnect.class);
        if (useConnectorResources) {
            kafkaConnect = ((KafkaConnectBuilder)((KafkaConnectFluent.MetadataNested)new KafkaConnectBuilder(kafkaConnect).editMetadata().addToAnnotations("strimzi.io/use-connector-resources", "true")).endMetadata()).build();
        }
        this.kafkaConnectOperation().createOrReplace((Object[])new KafkaConnect[]{kafkaConnect});
        kafkaConnect = this.waitForConnectCluster(kafkaConnect.getMetadata().getName());
        return new KafkaConnectController(kafkaConnect, this.ocp, this.http, useConnectorResources);
    }

    public Kafka waitForKafkaCluster(String name) throws InterruptedException {
        return (Kafka)((Resource)this.kafkaOperation().withName(name)).waitUntilCondition(this::waitForReadyStatus, 5L, TimeUnit.MINUTES);
    }

    public KafkaConnect waitForConnectCluster(String name) throws InterruptedException {
        return (KafkaConnect)((Resource)this.kafkaConnectOperation().withName(name)).waitUntilCondition(this::waitForReadyStatus, 5L, TimeUnit.MINUTES);
    }

    private <T extends Status> boolean waitForReadyStatus(HasStatus<T> kc) {
        return kc.getStatus() != null && kc.getStatus().getConditions().stream().anyMatch(c -> c.getType().equalsIgnoreCase("Ready") && c.getStatus().equalsIgnoreCase("True"));
    }

    public Secret deployPullSecret(String yamlPath) {
        LOGGER.info("Deploying Secret from " + yamlPath);
        return (Secret)((NonNamespaceOperation)this.ocp.secrets().inNamespace(this.project)).createOrReplace((Object[])new Secret[]{YAML.from(yamlPath, Secret.class)});
    }

    private NonNamespaceOperation<Kafka, KafkaList, DoneableKafka, Resource<Kafka, DoneableKafka>> kafkaOperation() {
        return (NonNamespaceOperation)Crds.kafkaOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    private NonNamespaceOperation<KafkaConnect, KafkaConnectList, DoneableKafkaConnect, Resource<KafkaConnect, DoneableKafkaConnect>> kafkaConnectOperation() {
        return (NonNamespaceOperation)Crds.kafkaConnectOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }
}

