/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases;

import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;

public class DatabaseController {
    private final Deployment deployment;
    private final List<Service> services;
    private final OpenShiftClient ocp;
    private final String project;
    private final String dbType;
    private final OpenShiftUtils ocpUtils;

    public DatabaseController(Deployment deployment, List<Service> services, String dbType, OpenShiftClient ocp) {
        this.deployment = deployment;
        this.services = services;
        this.ocp = ocp;
        this.project = deployment.getMetadata().getNamespace();
        this.dbType = dbType;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public String getDatabaseUrl() {
        Service svc = (Service)((ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName(this.deployment.getMetadata().getName() + "-lb")).get();
        LoadBalancerIngress ingress = (LoadBalancerIngress)svc.getStatus().getLoadBalancer().getIngress().get(0);
        String hostname = ingress.getHostname();
        Integer port = svc.getSpec().getPorts().stream().filter(p -> p.getName().equals("db")).findAny().get().getPort();
        return "jdbc:" + this.dbType + "://" + hostname + ":" + port;
    }
}

