/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.kafka;

import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.debezium.testing.openshift.tools.kafka.KafkaController;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaController.class);
    private final OpenShiftClient ocp;
    private final OpenShiftUtils ocpUtils;
    private String project;
    private Deployment operator;
    private String name;

    public OperatorController(Deployment operator, OpenShiftClient ocp) {
        this.operator = operator;
        this.name = operator.getMetadata().getName();
        this.project = operator.getMetadata().getNamespace();
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public Deployment setImagePullSecret(String secret) {
        LOGGER.info("Using " + secret + " as image pull secret for deployment '" + this.name + "'");
        List<LocalObjectReference> pullSecrets = Collections.singletonList(new LocalObjectReference(secret));
        this.ocpUtils.ensureHasPullSecret(this.operator, secret);
        return this.operator;
    }

    public Deployment setOperandImagePullSecrets(String names) {
        return this.setEnvVar("STRIMZI_IMAGE_PULL_SECRETS", names);
    }

    public Deployment setLogLevel(String level) {
        return this.setEnvVar("STRIMZI_LOG_LEVEL", level);
    }

    public Deployment setAlwaysPullPolicy() {
        return this.setEnvVar("STRIMZI_IMAGE_PULL_POLICY", "Always");
    }

    public Deployment setEnvVar(String name, String val) {
        LOGGER.info("Setting variable " + name + "=" + val + " on deployment '" + name + "'");
        this.ocpUtils.ensureHasEnv(this.operator, new EnvVar(name, val, null));
        return this.operator;
    }

    public Deployment updateOperator() throws InterruptedException {
        this.operator = (Deployment)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object[])new Deployment[]{this.operator});
        this.operator = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).waitUntilCondition(this::waitForAvailable, 5L, TimeUnit.MINUTES);
        return this.operator;
    }

    private boolean waitForAvailable(Deployment resource) {
        DeploymentStatus status = resource.getStatus();
        if (status == null) {
            return false;
        }
        Stream conditions = status.getConditions().stream();
        return conditions.anyMatch(c -> c.getType().equalsIgnoreCase("Available") && c.getStatus().equalsIgnoreCase("True"));
    }
}

